package com.biz.crm.mdm.admin.web.report.spu.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 商品spu信息分页查询dto
 *
 * @author pengxi
 * @date 2022/9/9
 */
@Data
@ApiModel(value = "VisitorProductSpuPaginationDto", description = "商品spu信息分页查询dto")
public class VisitorProductSpuPaginationDto {

  /** 业务编码,终端编码或客户编码 */
  @ApiModelProperty("业务编码，终端编码或客户编码")
  private String businessCode;

  /** 商品编码或名称精确查询 */
  @ApiModelProperty("商品编码或名称精确查询")
  private String keyword;

  /** 商品编码或名称like查询 */
  @ApiModelProperty("商品编码或名称like查询")
  private String likeKeyword;

  /** 产品层级 */
  @ApiModelProperty("产品层级，根据该过滤条件搜索当前及子级所有层级编码")
  private String productLevelCode;

  /** 标签集合搜索过滤 */
  @ApiModelProperty("标签集合搜索过滤，新品等")
  private List<String> spuTagList;

  /** 对应用户的可购清单全量的商品编码集合 */
  @ApiModelProperty(value = "对应用户的可购清单全量的商品编码集合", hidden = true)
  private List<String> productCodeList;

  /** 每页显示条数 */
  @ApiModelProperty(value = "每页显示条数")
  private Integer pageSize;

  /** 页码 */
  @ApiModelProperty(value = "页码")
  private Integer page;
}
