package com.biz.crm.mdm.admin.web.report.spu.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.spu.dto.VisitorProductSpuDto;
import org.apache.ibatis.annotations.Param;

import java.util.Set;

/**
 * 商品SPU管理电商数据关联操作mapper
 *
 * @author pengxi
 * @date 2022/9/9
 */
public interface VisitorProductSpuVoMapper {

  /**
   * 获取匹配的商品编码集合-可购清单分页查询关联使用
   *
   * @param dto
   * @return
   */
  Set<String> findProductCodeSet(@Param("dto") VisitorProductSpuDto dto);

  /**
   * 获取匹配的spu编码及排序信息
   *
   * @param page 分页信息
   * @param dto  参数dto
   * @return 分页列表
   */
  Page<String> findSpuCodePage(Page<VisitorProductSpuDto> page, @Param("dto") VisitorProductSpuDto dto);
}
