package com.biz.crm.mdm.admin.web.report.spu.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.admin.web.report.spu.dto.VisitorProductSpuDto;
import com.biz.crm.mdm.admin.web.report.spu.mapper.VisitorProductSpuVoMapper;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 商品SPU管理电商数据关联操作repository
 *
 * @author pengxi
 * @date 2022/9/9
 */
@Component
public class VisitorProductSpuVoRepository {

  @Autowired(required = false)
  private VisitorProductSpuVoMapper visitorProductSpuVoMapper;

  /**
   * 获取匹配的商品编码集合
   *
   * @param dto 查询dto
   * @return Set<String>
   */
  public Set<String> findProductCodeSet(VisitorProductSpuDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setIsShelf(IsShelfEnum.UP.getCode());
    return this.visitorProductSpuVoMapper.findProductCodeSet(dto);
  }

  /**
   * 获取匹配的spu编码及排序信息
   *
   * @param dto 查询dto
   * @return Page<String>
   */
  public Page<String> findSpuCodePage(Page<VisitorProductSpuDto> page, VisitorProductSpuDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setIsShelf(IsShelfEnum.UP.getCode());
    return this.visitorProductSpuVoMapper.findSpuCodePage(page, dto);
  }
}
