package com.biz.crm.mdm.admin.web.report.terminal.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * 有供货关系类终端report分页查询dto
 *
 * @author sunx
 * @date 2021/11/5
 */
@Data
@ApiModel(value = "TerminalSupplyReportPaginationDto", description = "有供货关系类终端report分页查询dto")
public class TerminalSupplyReportPaginationDto {

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 供货类型
   */
  @ApiModelProperty(value = "供货类型,default-默认，customer_user-客户用户", hidden = false)
  private String supplyType;

  /**
   * 启用状态
   */
  @ApiModelProperty(value = "启用状态")
  private String enableStatus;

  /**
   * 企业用户职位编码集合
   */
  @ApiModelProperty(value = "企业用户职位编码集合", hidden = false)
  private List<String> positionCodeList;

  /**
   * 删除标记
   */
  @ApiModelProperty(value = "删除标记", hidden = false)
  private String delFlag;

  /**
   * 租户编码
   */
  @ApiModelProperty(value = "租户编码", hidden = false)
  private String tenantCode;

  /**
   * 回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据
   */
  @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
  private List<String> selectedCode;
}
