package com.biz.crm.mdm.admin.web.report.user.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 用户下属VO
 *
 * @author pengxi
 * @date 2020-11-17 20:23:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户下属")
public class UserUnderlingDto extends TenantFlagOpDto {

  /**
   * 下属职位编码集合
   */
  @ApiModelProperty("下属职位编码集合")
  private List<String> underlingPositionCodeList;

  /**
   * 用户登录名
   */
  @ApiModelProperty("用户登录名")
  private String userName;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 下级职位编码
   */
  @ApiModelProperty("下级职位编码")
  private String underlingPositionCode;

  /**
   * 下级职位名称
   */
  @ApiModelProperty("下级职位名称")
  private String underlingPositionName;

  /**
   * 是否为下级主职位名称
   */
  @ApiModelProperty("是否为下级主职位名称: 1-是,0-否")
  private String underlingPrimaryFlag;

  /**
   * 下级登录账号
   */
  @ApiModelProperty("下级登录账号")
  private String underlingUserName;

  /**
   * 下级用户姓名
   */
  @ApiModelProperty("下级用户姓名")
  private String underlingFullName;

  /**
   * 下级组织编码
   */
  @ApiModelProperty("下级组织编码")
  private String underlingOrgCode;

  /**
   * 下级组织名称
   */
  @ApiModelProperty("下级组织名称")
  private String underlingOrgName;

  /**
   * 下级职位级别编码
   */
  @ApiModelProperty("下级职位级别编码")
  private String underlingPositionLevelCode;

  /**
   * 下级职位级别名称
   */
  @ApiModelProperty("下级职位级别名称")
  private String underlingPositionLevelName;

  /**
   * 下级登录用户账号或者姓名或者编码
   */
  @ApiModelProperty("下级登录用户账号或者姓名")
  private String underlingUserNameOrFullNameOrUserCode;

}
