package com.biz.crm.mdm.admin.web.report.user.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.user.dto.UserReportDto;
import com.biz.crm.mdm.admin.web.report.user.vo.UserReportVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserFeignDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 用户报表(User)表数据库访问层
 *
 * @author xi.peng
 * @since 2021-11-04 16:46:59
 */
public interface UserReportMapper {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<UserReportVo> findReportByConditions(Page<UserReportDto> page, @Param("dto") UserReportDto dto);

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<UserReportVo> findReportChildrenByConditions(Page<UserReportDto> page, @Param("dto") UserReportDto dto);

  /**
   * 按照条件查询用户集合
   *
   * @param dto 查询集合
   * @return 用户信息集合
   */
  List<UserReportVo> findByUserFeignDto(@Param("dto") UserFeignDto dto);
}

