package com.biz.crm.mdm.admin.web.report.user.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.admin.web.report.user.dto.UserReportDto;
import com.biz.crm.mdm.admin.web.report.user.repository.UserReportRepository;
import com.biz.crm.mdm.admin.web.report.user.service.UserReportVoService;
import com.biz.crm.mdm.admin.web.report.user.vo.UserReportVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserFeignDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 用户报表(User)表服务实现类
 *
 * @author xi.peng
 * @since 2021-11-04 16:47:03
 */
@Service
public class UserReportVoServiceImpl implements UserReportVoService {

  @Autowired(required = false)
  private UserReportRepository userReportRepository;

  @Autowired(required = false)
  private OrgVoService orgVoService;

  @Override
  public Page<UserReportVo> findByConditions(Pageable pageable, UserReportDto dto) {
    // 根据左树选中组织获取组织规则编码
    if (StringUtils.isNotBlank(dto.getOrgCode())) {
      OrgVo orgVo = this.orgVoService.findByOrgCode(dto.getOrgCode());
      if (orgVo != null) {
        dto.setOrgRuleCode(orgVo.getRuleCode());
      }
    }
    // TODO 返回信息获取上级组织、上级职位、上级用户等信息
    return this.userReportRepository.findByConditions(pageable, dto);
  }

  @Override
  public Page<UserReportVo> findChildrenOrAllByConditions(Pageable pageable, UserReportDto dto) {
    // 根据左树选中组织获取组织规则编码
    if (StringUtils.isNotBlank(dto.getOrgCode())) {
      OrgVo orgVo = this.orgVoService.findByOrgCode(dto.getOrgCode());
      if (orgVo != null) {
        dto.setOrgRuleCode(orgVo.getRuleCode());
      }
    }
    // TODO 返回信息获取上级组织、上级职位、上级用户等信息
    return this.userReportRepository.findChildrenByConditions(pageable, dto);
  }

  @Override
  public UserReportVo findByUserCode(String userCode) {
    if (StringUtils.isBlank(userCode)) {
      return null;
    }
    UserFeignDto userReportDto = new UserFeignDto();
    userReportDto.setUserCode(userCode);
    userReportDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    userReportDto.setTenantCode(TenantUtils.getTenantCode());
    List<UserReportVo> byConditions = this.userReportRepository.findByUserFeignDto(userReportDto);
    if (CollectionUtils.isEmpty(byConditions)) {
      return null;
    }
    return byConditions.get(0);
  }

}
