package com.biz.crm.mdm.admin.web.report.user.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.user.dto.UserUnderlingDto;
import com.biz.crm.mdm.admin.web.report.user.repository.UserUnderlingRepository;
import com.biz.crm.mdm.admin.web.report.user.service.UserUnderlingVoService;
import com.biz.crm.mdm.admin.web.report.user.vo.UserUnderlingVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 用户下属(User)表服务实现类
 *
 * @author xi.peng
 * @since 2021-11-04 16:47:03
 */
@Service
public class UserUnderlingVoServiceImpl implements UserUnderlingVoService {

  @Autowired(required = false)
  private UserUnderlingRepository userUnderlingRepository;

  @Override
  public Page<UserUnderlingVo> findByConditions(Pageable pageable, UserUnderlingDto dto) {
    if (StringUtils.isBlank(dto.getUserName())) {
      return new Page<>();
    }
    return this.userUnderlingRepository.findByConditions(pageable, dto);
  }

}
