package com.biz.crm.mdm.admin.web.report.user.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 职位返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "以职位维度的职位及关联用户、组织、上级信息")
public class UserDetailVo extends TenantFlagOpVo {

    /**
     * 职位编码
     */
    @ApiModelProperty("职位编码")
    private String positionCode;

    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称")
    private String positionName;

    /**
     * 关联组织编码
     */
    @ApiModelProperty("关联组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String orgName;

    /**
     * 职位级别编码
     */
    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    /**
     * 职位级别名称
     */
    @ApiModelProperty("职位级别名称")
    private String positionLevelName;

    /**
     * 是否主职位：true 是,false 否
     */
    @ApiModelProperty("是否主职位1是0否")
    private Boolean primaryFlag;

    /**
     * 是否当前职位：true 是,false 否
     */
    @ApiModelProperty("是否当前职位1是0否")
    private Boolean currentFlag;

    /**
     * 用户登录名
     */
    @ApiModelProperty("用户登录名")
    private String userName;

    /**
     * 用户姓名
     */
    @ApiModelProperty("用户姓名")
    private String fullName;

    /**
     * 用户电话
     */
    @ApiModelProperty("用户电话")
    private String userPhone;

    /**
     * 用户工号
     */
    @ApiModelProperty("用户工号")
    private String jobCode;

    /**
     * 用户编码
     */
    @ApiModelProperty("用户编码")
    private String userCode;

    /**
     * 用户的启用状态
     */
    @ApiModelProperty("用户的启用状态")
    private String userEnableStatus;

    /**
     * 上级职位编码
     */
    @ApiModelProperty("上级职位编码")
    private String parentCode;

    /**
     * 上级职位名称
     */
    @ApiModelProperty("上级职位名称")
    private String parentName;

    /**
     * 上级用户编码
     */
    @ApiModelProperty("上级用户编码")
    private String parentUserName;

    /**
     * 上级用户名称
     */
    @ApiModelProperty("上级用户名称")
    private String parentFullName;

    /**
     * 上级用户编码
     */
    @ApiModelProperty("上级用户编码")
    private String parentUserCode;

    /**
     * 上级组织编码
     */
    @ApiModelProperty("上级组织编码")
    private String parentOrgCode;

    /**
     * 上级组织名称
     */
    @ApiModelProperty("上级组织名称")
    private String parentOrgName;

    /**
     * 用户头像url
     */
    @ApiModelProperty("用户头像url")
    private String userHeadUrl;

}
