package com.biz.crm.mdm.admin.web.service.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import com.biz.crm.mdm.admin.web.service.PositionRoleVoService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.google.common.collect.Lists;

/**
 * 根据登录账号获取职位及角色信息
 *
 * @author pengxi
 */
@Service
public class PositionRoleVoServiceImpl implements PositionRoleVoService {
  
  @Autowired(required = false)
  private UserPositionVoService userPositionVoService;
  
  @Autowired(required = false)
  private PositionVoService positionVoService;
  
  @Override
  public List<PositionVo> findByAccount(String tenantCode, String account) {
    /*
     * 由于管理关系统是客户用户登录，所以确定用户的角色需要以下步骤：
     * 1、确认当前用户和职位的关联，以及这个职位关联了的角色（注意：用户与职级没有直接关联，与职位关联）
     * 2、组装，去重后返回
     */
    
    // 1、
    List<UserPositionVo> userPositionVos = userPositionVoService.findByUserName(tenantCode, account);
    if (CollectionUtils.isEmpty(userPositionVos)) {
      return Lists.newArrayList();
    }
    // 默认只获取主岗位所关联的角色集合
    Set<String> positionCodes = userPositionVos.stream()
        .filter(p -> p.getPrimaryFlag())
        .map(UserPositionVo::getPositionCode).collect(Collectors.toSet());
    return positionVoService.findByIdsOrCodes(null, new ArrayList<>(positionCodes));
  }
  
  @Override
  public List<PositionVo> findByAccountForCurrentPosition(String tenantCode, String account) {
    /*
     * 由于管理关系统是客户用户登录，所以确定用户的角色需要以下步骤：
     * 1、确认当前用户和职位的关联，以及这个职位关联了的角色（注意：用户与职级没有直接关联，与职位关联）
     * 2、组装，去重后返回
     */
    // 1、
    List<UserPositionVo> userPositionVos = userPositionVoService.findByUserName(tenantCode, account);
    if (CollectionUtils.isEmpty(userPositionVos)) {
      return Lists.newArrayList();
    }
    // 默认只获取主岗位所关联的角色集合
    Set<String> positionCodes = userPositionVos.stream()
        .filter(p -> p.getCurrentFlag())
        .map(UserPositionVo::getPositionCode).collect(Collectors.toSet());
    return positionVoService.findByIdsOrCodes(null, new ArrayList<>(positionCodes));
  }
}
