package com.biz.crm.mdm.business.party.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.party.feign.feign.internal.PartyFeignImpl;
import com.biz.crm.mdm.business.party.sdk.vo.DeliveryWayVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* @Description: 送达方对外feign
* @Param:
* @return:
* @Author: ZS
* @Date: 2022/12/23
*/
@FeignClient(
        name = "${mdm.feign-client.name:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = PartyFeignImpl.class)
public interface PartyFeign {


    /**
     * 通过送达方编码查找售达方
     * @param deliveryCodes
     * @return
     */
    @GetMapping("/v1/deliveryWay/deliveryWay/findByDeliveryCodes")
    Result<List<DeliveryWayVo>> findByDeliveryCodes(@RequestBody List<String> deliveryCodes);
}
