package com.biz.crm.mdm.business.party.feign.service.internal;

import com.biz.crm.mdm.business.party.feign.feign.PartyFeign;
import com.biz.crm.mdm.business.party.sdk.service.SellOrDeliveryWayService;
import com.biz.crm.mdm.business.party.sdk.vo.DeliveryWayVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Class SellOrDeliveryWayServiceImpl
 * @Description
 * @Author : ZS
 * @Date: 2022/12/23  11:06
 */
@Service
@Slf4j
public class SellOrDeliveryWayServiceImpl implements SellOrDeliveryWayService {

    @Autowired(required = false)
    private PartyFeign partyFeign;

    /**
     * 通过送达方编码查售达方
     * @param deliverycodes
     * @return
     */
    @Override
    public List<DeliveryWayVo> findByDeliveryCodes(List<String> deliverycodes) {
        return this.partyFeign.findByDeliveryCodes(deliverycodes).getResult();
    }
}
