package com.biz.crm.mdm.business.party.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.party.sdk.dto.DeliveryWayDto;
import com.biz.crm.mdm.business.party.sdk.dto.SubdueDto;
import com.biz.crm.mdm.business.party.sdk.service.DeliveryWayService;
import com.biz.crm.mdm.business.party.sdk.service.SellOrDeliveryWayService;
import com.biz.crm.mdm.business.party.sdk.vo.DeliveryWayVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * (DeliveryWayVo)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-08 12:05:57
 */
@RestController
@RequestMapping("/v1/deliveryWay/deliveryWay")
@Slf4j
@Api(tags = "门店主数据 deliveryWay送达方配置")
public class DeliveryWayController {

    /**
     * 服务对象
     */
    @Autowired
    private DeliveryWayService deliveryWayService;

    @Autowired(required = false)
    private SellOrDeliveryWayService sellOrDeliveryWayService;


    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/findByConditions")
    public Result<Page<DeliveryWayVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                        @ApiParam(name = "dto", value = "送达方配置配置表") DeliveryWayDto dto) {
        try {
            Page<DeliveryWayVo> page = this.deliveryWayService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 送达方搜索接口
     *
     * @param dto 对象
     */
    @ApiOperation(value = "通过预算维度表和销售机构查询维度信息表接口")
    @PostMapping
    public Result<DeliveryWayVo> searchInterface(@ApiParam(name = "dto", value = "预算管控配置表") @RequestBody SubdueDto dto) {
        try {
            DeliveryWayVo result = this.deliveryWayService.searchInterface(dto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 根据送达方名称，通过送达方名称获取对应送达方编码
     * @param deliveryWayName
     */
    @ApiOperation(value = "根据登录人账号，通过菜单编码获取对应维度消息")
    @GetMapping("/findByDeliveryWayCode")
    public Result<String> findByDeliveryWayCode(@RequestParam String deliveryWayName) {
        try {
            String deliveryWayCode = this.deliveryWayService.findByDeliveryWayCode(deliveryWayName);
            return (Result<String>) Result.ok(deliveryWayCode);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 根据送达方编码通查询所属销售机构部门
     *
     * @param deliveryWayCode
     */
    @ApiOperation(value = "根据送达方编码通查询所属销售机构部门")
    @GetMapping("/findBySalesOrganization")
    public Result<String> findBySalesOrganization(@RequestParam String deliveryWayCode) {
        try {
            String salesOrganization = this.deliveryWayService.findBySalesOrganization(deliveryWayCode);
            return (Result<String>) Result.ok(salesOrganization);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 更新送达方
     *
     * @param deliveryWayDto 请求参数dto
     * @return 职位送达方
     */
    @ApiOperation(value = "更新送达方")
    @PatchMapping("/update")
    public Result<DeliveryWayVo> update(@RequestBody DeliveryWayDto deliveryWayDto) {
        try {
            DeliveryWayVo deliveryWayVo =  this.deliveryWayService.update(deliveryWayDto);
            return Result.ok(deliveryWayVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过ID获取送达方信息
     * @param id 送达方ID
     * @return 操作结果
     */
    @ApiOperation(value = "通过ID获取送达方信息")
    @GetMapping("/findDetailById")
    public Result<DeliveryWayVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
        try {
            return Result.ok(this.deliveryWayService.findById(id));
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过送达方编码查找售达方
     * @param deliveryCodes
     * @return
     */
    @ApiOperation(value = "通过送达方编码查找售达方")
    @GetMapping("/findByDeliveryCodes")
    public Result<List<DeliveryWayVo>> findByDeliveryCodes(@RequestBody List<String> deliveryCodes){
        try {
            List<DeliveryWayVo> deliveryWayVoList = this.sellOrDeliveryWayService.findByDeliveryCodes(deliveryCodes);
            return Result.ok(deliveryWayVoList);

        }catch (RuntimeException e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

}


