package com.biz.crm.mdm.business.party.local.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.party.local.service.DeliveryWayVoService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

/**
 * 拉去MDG主数据的http接口
 *
 * @author makejava
 * @since 2022-11-08 12:05:57
 */
@RestController
@RequestMapping("/v1/deliveryWay/deliveryWayVo")
@Slf4j
@Api(tags = "门店主数据 deliveryWay送达方配置")
public class DeliveryWayVoController {


    /**
     * 服务对象
     */
    @Autowired
    private DeliveryWayVoService deliveryWayVoService;


    /**
     * 批量拉取 ECC 送达方数据
     *
     * @param dto 请求参数
     * @return 送达方
     */
    @ApiOperation(value = "批量拉取 ECC 送达方数据")
    @PostMapping(value = {"/pullClientList"})
    public Result<?> pullClientList(@RequestBody MasterDataMdgBaseDto dto) {
        try {
            this.deliveryWayVoService.pullClientList(dto);
            return Result.ok("批量拉取 ECC 送达方数据");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}