package com.biz.crm.mdm.business.party.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.party.sdk.dto.QueryDeliveryWayDto;
import com.biz.crm.mdm.business.party.sdk.service.DeliveryWayService;
import com.biz.crm.mdm.business.party.sdk.vo.QueryDeliveryWayVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * (QueryDeliveryWayController)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-08 12:05:57
 */
@RestController
@RequestMapping("/v1/deliveryWay/queryDeliveryWay")
@Slf4j
@Api(tags = "门店主数据 deliveryWay送达方配置")
public class QueryDeliveryWayController {

    /**
     * 服务对象
     */
    @Autowired
    private DeliveryWayService deliveryWayService;

    /**
     * 通过售达方所属编码和名称查询售达方编码和名称
     *
     * @param queryDeliveryWayDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "通过售达方所属编码和名称查询售达方编码和名称")
    @PostMapping("/findByDeliveryWayDto")
    public Result<List<QueryDeliveryWayVo>> findByDeliveryWayDto(@ApiParam(name = "dimensionControlsDto", value = "预算管控配置表") @RequestBody QueryDeliveryWayDto queryDeliveryWayDto) {
        try {
            List<QueryDeliveryWayVo> queryDeliveryWayVo = this.deliveryWayService.findByDeliveryWayDto(queryDeliveryWayDto);
            return Result.ok(queryDeliveryWayVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
