package com.biz.crm.mdm.business.party.local.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 送达方 1
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.5 14:23
 */
@Component
public class DeliveryWayDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "mdm_delivery_way_data_view";
    }

    @Override
    public String desc() {
        return "MDM 送达方设置数据视图";
    }

    @Override
    public String buildSql() {
        return "SELECT t.*," +
                "  t.business_format_code business_format_code_name" +
                "  FROM mdm_delivery_way t" +
                "  WHERE  t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "  AND t.tenant_code = :tenantCode ";
    }
}

