package com.biz.crm.mdm.business.party.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * (DimensionBudget)
 *
 * @author makejava
 * @since 2022-11-05 12:00:01
 */
@ApiModel(value = "DeliveryWay", description = "送达方")
@Data
@Entity(name = "mdm_delivery_way")
@org.hibernate.annotations.Table(appliesTo = "mdm_delivery_way", comment = "送达方")
@TableName("mdm_delivery_way")
@Table(
        name = "mdm_delivery_way",
        indexes = {
                @Index(name = "delivery_way_code_index1", unique = true, columnList = "delivery_way_code,tenant_code"),
                @Index(name = "delivery_way_code_index2", unique = false, columnList = "delivery_way_code"),
                @Index(name = "delivery_way_code_index3", unique = false, columnList = "erp_code"),
                @Index(name = "delivery_way_code_index4", unique = false, columnList = "sold_to_party_code"),
                @Index(name = "delivery_way_code_index5", unique = false, columnList = "sold_to_party_erp_code"),
        })
@EqualsAndHashCode(callSuper = true)
public class DeliveryWay extends TenantFlagOpEntity {

    private static final long serialVersionUID = -6685410877762284576L;
    /**
     * 送达方编码
     */
    @ApiModelProperty("送达方编码")
    @Column(name = "delivery_way_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '送达方编码'")
    private String deliveryWayCode;
    /**
     * 送达方编码
     */
    @ApiModelProperty("ERP编码")
    @Column(name = "erp_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT 'ERP编码'")
    private String erpCode;

    /**
     * 送达方名称
     */
    @ApiModelProperty("送达方名称")
    @Column(name = "delivery_way_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '送达方名称'")
    private String deliveryWayName;

    /**
     * 送达方类型
     */
    @ApiModelProperty("送达方类型名称")
    @Column(name = "type_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '送达方类型名称'")
    private String typeName;

    /**
     * 送达方类型编码
     */
    @ApiModelProperty("送达方类型编码")
    @Column(name = "type_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '送达方类型编码'")
    private String typeCode;

    /**
     * 所属售达方编码
     */
    @ApiModelProperty("所属售达方ERP编码")
    @Column(name = "sold_to_party_erp_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '所属售达方ERP编码'")
    private String soldToPartyErpCode;

    /**
     * 所属售达方编码
     */
    @ApiModelProperty("所属售达方编码")
    @Column(name = "sold_to_party_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '所属售达方编码'")
    private String soldToPartyCode;

    /**
     * 所属售达方
     */
    @ApiModelProperty("所属售达方名称")
    @Column(name = "sold_to_party_name", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '所属售达方名称'")
    private String soldToPartyName;

    /**
     * 所属客户渠道 区域
     */
    @ApiModelProperty("customer_channel_name")
    @Column(name = "customer_channel_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '所属客户渠道'")
    private String customerChannelName;


    /**
     * 所属客户渠道编码
     */
    @ApiModelProperty("所属客户渠道编码")
    @Column(name = "customer_channel_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '所属客户渠道编码'")
    private String customerChannelCode;

    /**
     * 业态编码
     */
    @ApiModelProperty("业态编码")
    @Column(name = "business_format_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '业态编码'")
    private String businessFormatCode;

    @ApiModelProperty("所属销售机构ERP编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构ERP编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区ERP编码")
    @Column(name = "sales_region_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区ERP编码 '")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区编码 '")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属销售大区编码 '")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)ERP编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组织(组)ERP编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;


    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售组织(组)名称'")
    private String salesOrgName;

    /**
     * 省
     */
    @ApiModelProperty("省")
    @Column(name = "province", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '省'")
    private String province;

    /**
     * 市
     */
    @ApiModelProperty("市")
    @Column(name = "city", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '市'")
    private String city;

    /**
     * 区
     */
    @ApiModelProperty("区")
    @Column(name = "district", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '区'")
    private String district;


    /**
     * 收获地址
     */
    @ApiModelProperty("收获地址")
    @Column(name = "harvest_address", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '收获地址'")
    private String harvestAddress;

    /**
     * 收获联系人
     */
    @ApiModelProperty("收获联系人")
    @Column(name = "harvest_contact_persons", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '收获联系人'")
    private String harvestContactPersons;

    /**
     * 收获联系方式
     */
    @ApiModelProperty("收获联系方式")
    @Column(name = "harvest_contact_phone", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '收获联系方式'")
    private String harvestContactPhone;
}
