package com.biz.crm.mdm.business.party.local.jobs;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.party.local.service.DeliveryWayVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Description 送达方同步
 * @Author YangWei
 * @Date 2023/3/6 下午4:05
 */
@Slf4j
@Service
public class DeliveryWaySyncXxlJob {

    /**
     * 服务对象
     */
    @Autowired
    private DeliveryWayVoService deliveryWayVoService;

    /**
     * 销售组织自动更新定时任务 每天4点自动执行
     */
    @DynamicTaskService(cornExpression = "0 0 4 * * ?", taskDesc = "(送达方)批量拉取 ECC 客户数据")
    public void autoSyncXxlJob() {
        //TODO  需要改成  定时任务分片+redis锁
        log.info("=====>    送达方同步[{}] start    <=====", DateUtil.dateStrNowAll());
        MasterDataMdgBaseDto dto = new MasterDataMdgBaseDto();
        dto.setFullPullFlag(BooleanEnum.TRUE.getCapital());
        this.deliveryWayVoService.pullClientList(dto);
        log.info("=====>    送达方同步[{}] end    <=====", DateUtil.dateStrNowAll());

    }
}