package com.biz.crm.mdm.business.party.local.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.party.sdk.dto.DeliveryWayDto;
import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.mdm.business.party.local.entity.DeliveryWay;
import com.biz.crm.mdm.business.party.sdk.dto.SubdueDto;
import com.biz.crm.mdm.business.party.sdk.vo.DeliveryWayVo;

import java.util.List;

/**
 * 送达方的Mapper
 */
public interface DeliveryWayMapper extends BaseMapper<DeliveryWay> {

    /**
     * 分页条件查询物料单位
     *
     * @param pageable 分页信息
     * @param dto      查询筛选条件
     * @return 分页数据
     */
    Page<DeliveryWayVo> findByConditions(Page<DeliveryWayVo> pageable, @Param("dto") DeliveryWayDto dto);

    /**
     * 送达方搜索接口
     *
     * @param dto 对象
     */
    DeliveryWayVo searchInterface(@Param("dto") SubdueDto dto);

    DeliveryWayVo findById(@Param("id") String id, @Param("tenantCode") String tenantCode);

    /**
     * xml 新增
     *
     * @param list
     */
    void saveBatchForXml(@Param("list") List<DeliveryWay> list);
}
