package com.biz.crm.mdm.business.party.local.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.party.local.entity.DeliveryWay;
import com.biz.crm.mdm.business.party.local.mapper.DeliveryWayMapper;
import com.biz.crm.mdm.business.party.sdk.dto.DeliveryWayDto;
import com.biz.crm.mdm.business.party.sdk.dto.QueryDeliveryWayDto;
import com.biz.crm.mdm.business.party.sdk.dto.SubdueDto;
import com.biz.crm.mdm.business.party.sdk.vo.DeliveryWayVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

/**
 * (DeliveryWayVo)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-03 17:06:39
 */

@Component
public class DeliveryWayRepository extends ServiceImpl<DeliveryWayMapper, DeliveryWay> {

    @Autowired
    private DeliveryWayMapper deliveryWayMapper;

    /**
     * 分页查询数据
     *
     * @param dto 送达方查询参数
     * @param dto 实体对象
     * @return
     */
    public Page<DeliveryWayVo> findByConditions(Page<DeliveryWayVo> pageable, DeliveryWayDto dto) {
        // 过滤多租户
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.baseMapper.findByConditions(pageable, dto);
    }

    /**
     * 送达方搜索接口
     *
     * @param dto 对象
     */
    public DeliveryWayVo searchInterface(SubdueDto dto) {
        return deliveryWayMapper.searchInterface(dto);
    }

    /**
     * 根据送达方名称，通过送达方名称获取对应送达方编码
     *
     * @param deliveryWayName
     */
    public DeliveryWay findByDeliveryWayCode(String deliveryWayName) {
        return this.lambdaQuery().eq(DeliveryWay::getDeliveryWayName, deliveryWayName)
                .eq(DeliveryWay::getTenantCode, TenantUtils.getTenantCode())
                .eq(DeliveryWay::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).one();
    }

    /**
     * 根据送达方名称，通过送达方名称获取对应送达方编码
     *
     * @param deliveryWayCoding
     */
    public DeliveryWay findBySalesOrganization(String deliveryWayCoding) {
        return this.lambdaQuery().eq(DeliveryWay::getDeliveryWayCode, deliveryWayCoding)
                .eq(DeliveryWay::getTenantCode, TenantUtils.getTenantCode())
                .eq(DeliveryWay::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).one();
    }

    /**
     * 通过售达方所属编码和名称查询售达方编码和名称
     *
     * @param queryDeliveryWayDto 查询实体
     * @return 所有数据
     */
    public List<DeliveryWay> queryByQueryDeliveryWayDto(QueryDeliveryWayDto queryDeliveryWayDto) {
        return this.lambdaQuery()
                .eq(DeliveryWay::getSoldToPartyCode, queryDeliveryWayDto.getSoldToPartyCode())
                .eq(DeliveryWay::getSoldToPartyName, queryDeliveryWayDto.getSoldToPartyName())
                .eq(DeliveryWay::getTenantCode, TenantUtils.getTenantCode())
                .eq(DeliveryWay::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
    }

    /**
     * 根据主健筛选出送达方数据
     */
    public DeliveryWay findByWayId(String deliveryWayDtoId) {
        return this.lambdaQuery().eq(DeliveryWay::getTenantCode, TenantUtils.getTenantCode())
                .eq(DeliveryWay::getId, deliveryWayDtoId).eq(DeliveryWay::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list().stream().findFirst().orElse(null);
    }

    /**
     * MDG对接 根据编码查送达方数据
     */
    public List<DeliveryWay> findByDeliveryWayCodingLists(List<String> deliveryWayCodeList) {
        return this.lambdaQuery()
                .eq(DeliveryWay::getTenantCode, TenantUtils.getTenantCode())
                .in(DeliveryWay::getDeliveryWayCode, deliveryWayCodeList)
                .list();
    }

    /**
     * 查详情
     */
    public DeliveryWayVo findById(String id, String tenantCode) {
        return this.baseMapper.findById(id, tenantCode);
    }

    /**
     * 通过送达方编码集合查找对应的售达方
     *
     * @param deliveryCodes
     * @param tenantCode
     * @return
     */
    public List<DeliveryWay> findByDeliveryCodes(List<String> deliveryCodes, String tenantCode) {
        if (CollectionUtils.isEmpty(deliveryCodes)) {
            return new ArrayList<>();
        }
        return lambdaQuery()
                .eq(DeliveryWay::getTenantCode, tenantCode)
                .in(DeliveryWay::getDeliveryWayCode, deliveryCodes)
                .list();
    }

    public void deleteBatchByCodeList(List<String> deliveryWayCodeList) {
        if (CollectionUtils.isEmpty(deliveryWayCodeList)) {
            return;
        }
        this.lambdaUpdate()
                .eq(DeliveryWay::getTenantCode, TenantUtils.getTenantCode())
                .in(DeliveryWay::getDeliveryWayCode, deliveryWayCodeList)
                .remove();
    }

    /**
     * 批量新增
     * @param list
     */
    public void saveBatchForXml(List<DeliveryWay> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.baseMapper.saveBatchForXml(list);
    }
}
