package com.biz.crm.mdm.business.party.local.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.biz.crm.mdm.business.party.local.entity.DeliveryWay;
import com.biz.crm.mdm.business.party.local.repository.DeliveryWayRepository;
import com.biz.crm.mdm.business.party.sdk.service.SellOrDeliveryWayService;
import com.biz.crm.mdm.business.party.sdk.vo.DeliveryWayVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * @Class SellOrDeliveryWayServiceImpl 1
 * @Description
 * @Author : ZS
 * @Date: 2022/12/23  10:53
 */

@Slf4j
@Service
public class SellOrDeliveryWayServiceImpl implements SellOrDeliveryWayService {

    @Autowired(required = false)
    private DeliveryWayRepository deliveryWayRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 通过送达方编码查找对应的售达方
     * @param deliverycodes
     * @return
     */
    @Override
    public List<DeliveryWayVo> findByDeliveryCodes(List<String> deliverycodes) {
        List<DeliveryWay> entitys = this.deliveryWayRepository.findByDeliveryCodes(deliverycodes, TenantUtils.getTenantCode());
        List<DeliveryWayVo> deliveryWayVoList = (List<DeliveryWayVo>) this.nebulaToolkitService.copyCollectionByWhiteList(entitys,DeliveryWay.class,DeliveryWayVo.class, HashSet.class, ArrayList.class);
        return deliveryWayVoList;
    }
}
