/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.party.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.party.sdk.dto.DeliveryWayDto;
import com.biz.crm.mdm.business.party.sdk.dto.SubdueDto;
import com.biz.crm.mdm.business.party.sdk.service.DeliveryWayService;
import com.biz.crm.mdm.business.party.sdk.service.SellOrDeliveryWayService;
import com.biz.crm.mdm.business.party.sdk.vo.DeliveryWayVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/deliveryWay/deliveryWay"})
@Api(tags={"\u95e8\u5e97\u4e3b\u6570\u636e deliveryWay\u9001\u8fbe\u65b9\u914d\u7f6e"})
public class DeliveryWayController {
    private static final Logger log = LoggerFactory.getLogger(DeliveryWayController.class);
    @Autowired
    private DeliveryWayService deliveryWayService;
    @Autowired(required=false)
    private SellOrDeliveryWayService sellOrDeliveryWayService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<DeliveryWayVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u9001\u8fbe\u65b9\u914d\u7f6e\u914d\u7f6e\u8868") DeliveryWayDto dto) {
        try {
            Page page = this.deliveryWayService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u9884\u7b97\u7ef4\u5ea6\u8868\u548c\u9500\u552e\u673a\u6784\u67e5\u8be2\u7ef4\u5ea6\u4fe1\u606f\u8868\u63a5\u53e3")
    @PostMapping
    public Result<DeliveryWayVo> searchInterface(@ApiParam(name="dto", value="\u9884\u7b97\u7ba1\u63a7\u914d\u7f6e\u8868") @RequestBody SubdueDto dto) {
        try {
            DeliveryWayVo result = this.deliveryWayService.searchInterface(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u767b\u5f55\u4eba\u8d26\u53f7\uff0c\u901a\u8fc7\u83dc\u5355\u7f16\u7801\u83b7\u53d6\u5bf9\u5e94\u7ef4\u5ea6\u6d88\u606f")
    @GetMapping(value={"/findByDeliveryWayCode"})
    public Result<String> findByDeliveryWayCode(@RequestParam String deliveryWayName) {
        try {
            String deliveryWayCode = this.deliveryWayService.findByDeliveryWayCode(deliveryWayName);
            return Result.ok((String)deliveryWayCode);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9001\u8fbe\u65b9\u7f16\u7801\u901a\u67e5\u8be2\u6240\u5c5e\u9500\u552e\u673a\u6784\u90e8\u95e8")
    @GetMapping(value={"/findBySalesOrganization"})
    public Result<String> findBySalesOrganization(@RequestParam String deliveryWayCode) {
        try {
            String salesOrganization = this.deliveryWayService.findBySalesOrganization(deliveryWayCode);
            return Result.ok((String)salesOrganization);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u9001\u8fbe\u65b9")
    @PatchMapping(value={"/update"})
    public Result<DeliveryWayVo> update(@RequestBody DeliveryWayDto deliveryWayDto) {
        try {
            DeliveryWayVo deliveryWayVo = this.deliveryWayService.update(deliveryWayDto);
            return Result.ok((Object)deliveryWayVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u9001\u8fbe\u65b9\u4fe1\u606f")
    @GetMapping(value={"/findDetailById"})
    public Result<DeliveryWayVo> findById(@RequestParam(value="id", required=false) @ApiParam(name="id", value="\u4e3b\u952eID") String id) {
        try {
            return Result.ok((Object)this.deliveryWayService.findById(id));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u9001\u8fbe\u65b9\u7f16\u7801\u67e5\u627e\u552e\u8fbe\u65b9")
    @GetMapping(value={"/findByDeliveryCodes"})
    public Result<List<DeliveryWayVo>> findByDeliveryCodes(@RequestBody List<String> deliveryCodes) {
        try {
            List deliveryWayVoList = this.sellOrDeliveryWayService.findByDeliveryCodes(deliveryCodes);
            return Result.ok((Object)deliveryWayVoList);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

