/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.party.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.party.local.entity.DeliveryWay;
import com.biz.crm.mdm.business.party.local.mapper.DeliveryWayMapper;
import com.biz.crm.mdm.business.party.sdk.dto.DeliveryWayDto;
import com.biz.crm.mdm.business.party.sdk.dto.QueryDeliveryWayDto;
import com.biz.crm.mdm.business.party.sdk.dto.SubdueDto;
import com.biz.crm.mdm.business.party.sdk.vo.DeliveryWayVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DeliveryWayRepository
extends ServiceImpl<DeliveryWayMapper, DeliveryWay> {
    @Autowired
    private DeliveryWayMapper deliveryWayMapper;

    public Page<DeliveryWayVo> findByConditions(Page<DeliveryWayVo> pageable, DeliveryWayDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((DeliveryWayMapper)this.baseMapper).findByConditions(pageable, dto);
    }

    public DeliveryWayVo searchInterface(SubdueDto dto) {
        return this.deliveryWayMapper.searchInterface(dto);
    }

    public DeliveryWay findByDeliveryWayCode(String deliveryWayName) {
        return (DeliveryWay)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeliveryWay::getDeliveryWayName, (Object)deliveryWayName)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public DeliveryWay findBySalesOrganization(String deliveryWayCoding) {
        return (DeliveryWay)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeliveryWay::getDeliveryWayCode, (Object)deliveryWayCoding)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<DeliveryWay> queryByQueryDeliveryWayDto(QueryDeliveryWayDto queryDeliveryWayDto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeliveryWay::getSoldToPartyCode, (Object)queryDeliveryWayDto.getSoldToPartyCode())).eq(DeliveryWay::getSoldToPartyName, (Object)queryDeliveryWayDto.getSoldToPartyName())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public DeliveryWay findByWayId(String deliveryWayDtoId) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidEntity::getId, (Object)deliveryWayDtoId)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list().stream().findFirst().orElse(null);
    }

    public List<DeliveryWay> findByDeliveryWayCodingLists(List<String> deliveryWayCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(DeliveryWay::getDeliveryWayCode, deliveryWayCodeList)).list();
    }

    public DeliveryWayVo findById(String id, String tenantCode) {
        return ((DeliveryWayMapper)this.baseMapper).findById(id, tenantCode);
    }

    public List<DeliveryWay> findByDeliveryCodes(List<String> deliveryCodes, String tenantCode) {
        if (CollectionUtils.isEmpty(deliveryCodes)) {
            return new ArrayList<DeliveryWay>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(DeliveryWay::getDeliveryWayCode, deliveryCodes)).list();
    }

    public void deleteBatchByCodeList(List<String> deliveryWayCodeList) {
        if (CollectionUtils.isEmpty(deliveryWayCodeList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(DeliveryWay::getDeliveryWayCode, deliveryWayCodeList)).remove();
    }

    public void saveBatchForXml(List<DeliveryWay> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ((DeliveryWayMapper)this.baseMapper).saveBatchForXml(list);
    }
}

