/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.party.local.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.party.local.entity.DeliveryWay;
import com.biz.crm.mdm.business.party.local.repository.DeliveryWayRepository;
import com.biz.crm.mdm.business.party.sdk.dto.DeliveryWayDto;
import com.biz.crm.mdm.business.party.sdk.dto.QueryDeliveryWayDto;
import com.biz.crm.mdm.business.party.sdk.dto.SubdueDto;
import com.biz.crm.mdm.business.party.sdk.service.DeliveryWayService;
import com.biz.crm.mdm.business.party.sdk.vo.DeliveryWayVo;
import com.biz.crm.mdm.business.party.sdk.vo.QueryDeliveryWayVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryWayService")
public class DeliveryWayServiceImpl
implements DeliveryWayService {
    private static final Logger log = LoggerFactory.getLogger(DeliveryWayServiceImpl.class);
    @Autowired
    private DeliveryWayRepository deliveryWayRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<DeliveryWayVo> findByConditions(Pageable pageable, DeliveryWayDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new DeliveryWayDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.deliveryWayRepository.findByConditions((Page<DeliveryWayVo>)page, dto);
    }

    public DeliveryWayVo searchInterface(SubdueDto dto) {
        DeliveryWayVo deliveryWayVo = this.deliveryWayRepository.searchInterface(dto);
        if (ObjectUtils.isEmpty((Object)deliveryWayVo)) {
            throw new RuntimeException("\u67e5\u8be2\u6570\u636e\u4e0d\u4e0d\u5b58\u5728\uff01");
        }
        return deliveryWayVo;
    }

    public String findByDeliveryWayCode(String deliveryWayName) {
        Validate.notNull((Object)deliveryWayName, (String)"\u9001\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DeliveryWay deliveryWay = this.deliveryWayRepository.findByDeliveryWayCode(deliveryWayName);
        Validate.notNull((Object)deliveryWayName, (String)"\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        System.out.println("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728" + deliveryWay.getDeliveryWayCode());
        return deliveryWay.getDeliveryWayCode();
    }

    public String findBySalesOrganization(String deliveryWayCode) {
        Validate.notNull((Object)deliveryWayCode, (String)"\u9001\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DeliveryWay deliveryWay = this.deliveryWayRepository.findBySalesOrganization(deliveryWayCode);
        Validate.notNull((Object)((Object)deliveryWay), (String)"\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        return deliveryWay.getSalesInstitutionName();
    }

    public List<QueryDeliveryWayVo> findByDeliveryWayDto(QueryDeliveryWayDto queryDeliveryWayDto) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)queryDeliveryWayDto.getSoldToPartyName()), (String)"\u6240\u5c5e\u552e\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)queryDeliveryWayDto.getSoldToPartyName()), (String)"\u6240\u5c5e\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<DeliveryWay> deliveryWay = this.deliveryWayRepository.queryByQueryDeliveryWayDto(queryDeliveryWayDto);
        ArrayList<QueryDeliveryWayVo> deliveryWayVoList = new ArrayList<QueryDeliveryWayVo>();
        if (deliveryWay == null) {
            return new ArrayList<QueryDeliveryWayVo>();
        }
        deliveryWay.forEach(aa -> {
            QueryDeliveryWayVo deliveryWayVo = new QueryDeliveryWayVo();
            deliveryWayVo.setDeliveryWayName(aa.getSoldToPartyName());
            deliveryWayVo.setDeliveryWayCode(aa.getSoldToPartyName());
            deliveryWayVoList.add(deliveryWayVo);
        });
        return deliveryWayVoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public DeliveryWayVo update(DeliveryWayDto deliveryWayDto) {
        this.updateValidation(deliveryWayDto);
        String deliveryWayDtoId = deliveryWayDto.getId();
        DeliveryWay deliveryWay = this.deliveryWayRepository.findByWayId(deliveryWayDtoId);
        Validate.notNull((Object)((Object)deliveryWay), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        deliveryWay.setTenantCode(TenantUtils.getTenantCode());
        Validate.isTrue((boolean)deliveryWayDto.getDeliveryWayCode().equals(deliveryWay.getDeliveryWayCode()), (String)"\u9001\u8fbe\u65b9\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        DeliveryWay deliveryWay1 = (DeliveryWay)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)deliveryWayDto, DeliveryWay.class, HashSet.class, ArrayList.class, new String[0]));
        this.deliveryWayRepository.saveOrUpdate((Object)deliveryWay1);
        return (DeliveryWayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)deliveryWay1, DeliveryWayVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public DeliveryWayVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DeliveryWayVo deliveryWayVo = this.deliveryWayRepository.findById(id, TenantUtils.getTenantCode());
        Validate.notNull((Object)deliveryWayVo, (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        return deliveryWayVo;
    }

    private void updateValidation(DeliveryWayDto deliveryWayDto) {
        this.validation(deliveryWayDto);
    }

    private void validation(DeliveryWayDto deliveryWayDto) {
        Validate.notBlank((CharSequence)deliveryWayDto.getDeliveryWayCode(), (String)"\u8bf7\u9009\u62e9\u9001\u8fbe\u65b9\u7c7b\u578b\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliveryWayDto.getDeliveryWayName(), (String)"\u8bf7\u9009\u62e9\u9001\u8fbe\u65b9\u540d\u79f0", (Object[])new Object[0]);
        Validate.notNull((Object)deliveryWayDto.getTypeName(), (String)"\u9001\u8fbe\u65b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)deliveryWayDto.getTypeCode(), (String)"\u9001\u8fbe\u65b9\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

