/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.party.local.service.impl;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.party.local.entity.DeliveryWay;
import com.biz.crm.mdm.business.party.local.repository.DeliveryWayRepository;
import com.biz.crm.mdm.business.party.local.service.DeliveryWayVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgClientVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryWayVoService")
public class DeliveryWayVoServiceImpl
implements DeliveryWayVoService {
    private static final Logger log = LoggerFactory.getLogger(DeliveryWayVoServiceImpl.class);
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private MasterDataMdgService masterDataMdgService;
    @Autowired(required=false)
    private DeliveryWayRepository deliveryWayRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullClientList(MasterDataMdgBaseDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new MasterDataMdgBaseDto();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageNum())) {
            dto.setPageNum("1");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageSize())) {
            dto.setPageSize("400");
        }
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        boolean lock = true;
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            AtomicLong failCount = new AtomicLong(0L);
            List masterDataMdgClientVos = null;
            int maxPage = 0;
            maxPage = BooleanEnum.TRUE.getCapital().equals(dto.getFullPullFlag()) ? this.countPageMax(dto) : Integer.parseInt(dto.getPageNum());
            for (int pageNum = Integer.parseInt(dto.getPageNum()); pageNum <= maxPage; ++pageNum) {
                dto.setPageNum(Integer.toString(pageNum));
                masterDataMdgClientVos = this.masterDataMdgService.pullClientList(dto);
                if (CollectionUtils.isEmpty((Collection)masterDataMdgClientVos)) {
                    return;
                }
                List<DeliveryWay> pullList = this.supplierValidateClient(masterDataMdgClientVos, failCount);
                log.info("\u5f53\u524d\u62c9\u53d6\u8fdb\u5ea6\uff1a" + pageNum + "/" + maxPage + "\uff0c\u6bcf\u9875" + dto.getPageSize() + "\u6761\u6570\u636e\uff0c\u62c9\u53d6\u5931\u8d25\u7684\u6570\u636e\u5171" + failCount.get() + "\u6761");
                failCount.set(0L);
                List<String> deliveryWayCodeList = pullList.stream().map(DeliveryWay::getDeliveryWayCode).collect(Collectors.toList());
                List<DeliveryWay> deliveryWays = this.deliveryWayRepository.findByDeliveryWayCodingLists(deliveryWayCodeList);
                if (CollectionUtils.isEmpty(deliveryWays)) {
                    this.saveOrUpdateBatch(pullList, null);
                    continue;
                }
                ArrayList<DeliveryWay> saveList = new ArrayList<DeliveryWay>();
                ArrayList<DeliveryWay> updateList = new ArrayList<DeliveryWay>();
                Map<String, DeliveryWay> map = deliveryWays.stream().collect(Collectors.toMap(DeliveryWay::getDeliveryWayCode, v -> v, (oldValue, newValue) -> newValue));
                pullList.forEach(pull -> {
                    DeliveryWay oldEntity = (DeliveryWay)((Object)((Object)map.get(pull.getDeliveryWayCode())));
                    if (Objects.nonNull((Object)oldEntity)) {
                        pull.setId(oldEntity.getId());
                        pull.setCreateAccount(oldEntity.getCreateAccount());
                        pull.setCreateName(oldEntity.getCreateName());
                        pull.setCreateTime(oldEntity.getCreateTime());
                        updateList.add((DeliveryWay)((Object)pull));
                    } else {
                        saveList.add((DeliveryWay)((Object)pull));
                    }
                });
                this.saveOrUpdateBatch(saveList, updateList);
            }
        }
        finally {
            if (lock) {
                this.unlockClient(lockKey);
            }
        }
    }

    private int countPageMax(MasterDataMdgBaseDto dto) {
        Integer totalNum = this.masterDataMdgService.countList("/ecc_client_tpm", dto.getDs(), dto.getUdate());
        int maxPage = 1;
        int sizeInt = Integer.parseInt(dto.getPageSize());
        if (totalNum > sizeInt) {
            maxPage = totalNum % sizeInt > 0 ? totalNum / sizeInt + 1 : totalNum / sizeInt;
        }
        return maxPage;
    }

    @Transactional(rollbackFor={Exception.class})
    void saveOrUpdateBatch(List<DeliveryWay> saveList, List<DeliveryWay> updateList) {
        if (!CollectionUtils.isEmpty(saveList)) {
            AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
            String username = userIdentity.getUsername();
            String realName = userIdentity.getRealName();
            Date nowDate = new Date();
            String tenantCode = TenantUtils.getTenantCode();
            saveList.forEach(entity -> {
                if (StringUtils.isEmpty((CharSequence)entity.getId())) {
                    entity.setId(UuidCrmUtil.general());
                }
                entity.setCreateAccount(username);
                entity.setCreateName(realName);
                entity.setCreateTime(nowDate);
                entity.setTenantCode(tenantCode);
                if (StringUtils.isEmpty((CharSequence)entity.getDelFlag())) {
                    entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                }
                if (StringUtils.isEmpty((CharSequence)entity.getEnableStatus())) {
                    entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                }
            });
            this.deliveryWayRepository.saveBatchForXml(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.deliveryWayRepository.updateBatchById(updateList);
        }
    }

    private void unlockClient(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u9500\u552e\u529e\u516c\u5ba4\u5173\u7cfb\u4e3b\u6570\u636e\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisMutexService.unlock("client_lock:lock:" + yearMonthDay);
    }

    private boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u9500\u552e\u529e\u516c\u5ba4\u5173\u7cfb\u4e3b\u6570\u636e\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisMutexService.tryLock("client_lock:lock:" + yearMonthDay, TimeUnit.HOURS, 12);
    }

    private List<DeliveryWay> supplierValidateClient(List<MasterDataMdgClientVo> mdgVoList, AtomicLong failCount) {
        ArrayList pullList = new ArrayList();
        String tenantCode = TenantUtils.getTenantCode();
        String enableStatus = DelFlagStatusEnum.NORMAL.getCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        mdgVoList.forEach(mdgVo -> {
            if (StringUtils.isEmpty((CharSequence)mdgVo.getKunn2())) {
                log.error("\u672c\u6b21\u62c9\u53d6\u6570\u636e\u9001\u8fbe\u65b9\u7f16\u7801\u4e3a\u7a7a\uff1a" + mdgVo);
                failCount.getAndIncrement();
                return;
            }
            if (StringUtils.isEmpty((CharSequence)mdgVo.getVkorg())) {
                log.error("\u672c\u6b21\u62c9\u53d6\u6570\u636e\u9500\u552e\u673a\u6784\u7f16\u7801\u4e3a\u7a7a\uff1a" + mdgVo);
                failCount.getAndIncrement();
                return;
            }
            if (StringUtils.isEmpty((CharSequence)mdgVo.getVtweg())) {
                log.error("\u672c\u6b21\u62c9\u53d6\u6570\u636e\u6e20\u9053\u7f16\u7801\u4e3a\u7a7a\uff1a" + mdgVo);
                failCount.getAndIncrement();
                return;
            }
            if (StringUtils.isEmpty((CharSequence)mdgVo.getSpart())) {
                log.error("\u672c\u6b21\u62c9\u53d6\u6570\u636e\u4e1a\u6001\u7f16\u7801\u4e3a\u7a7a\uff1a" + mdgVo);
                failCount.getAndIncrement();
                return;
            }
            mdgVo.setKunn2(StringUtils.trimToEmpty((String)mdgVo.getKunn2()));
            mdgVo.setKunnr(StringUtils.trimToEmpty((String)mdgVo.getKunnr()));
            mdgVo.setVkorg(StringUtils.trimToEmpty((String)mdgVo.getVkorg()));
            mdgVo.setVtweg(StringUtils.trimToEmpty((String)mdgVo.getVtweg()));
            mdgVo.setSpart(StringUtils.trimToEmpty((String)mdgVo.getSpart()));
            mdgVo.setVkbur(StringUtils.trimToEmpty((String)mdgVo.getVkbur()));
            mdgVo.setVkgrp(StringUtils.trimToEmpty((String)mdgVo.getVkgrp()));
            String deliveryWayCode = mdgVo.getKunn2() + mdgVo.getVkorg() + mdgVo.getVtweg() + mdgVo.getSpart();
            DeliveryWay deliveryWay = new DeliveryWay();
            deliveryWay.setDeliveryWayCode(deliveryWayCode);
            deliveryWay.setErpCode(mdgVo.getKunn2());
            deliveryWay.setDeliveryWayName(mdgVo.getName1());
            if (StringUtils.isNotBlank((CharSequence)mdgVo.getKunnr())) {
                String soldToPartyCode = mdgVo.getKunnr() + mdgVo.getVkorg() + mdgVo.getVtweg() + mdgVo.getSpart();
                deliveryWay.setSoldToPartyCode(soldToPartyCode);
            }
            deliveryWay.setSoldToPartyErpCode(mdgVo.getKunnr());
            deliveryWay.setCustomerChannelCode(mdgVo.getVtweg());
            deliveryWay.setBusinessFormatCode(mdgVo.getSpart());
            String salesOrgCode = deliveryWay.getCustomerChannelCode() + deliveryWay.getBusinessFormatCode() + mdgVo.getVkorg();
            deliveryWay.setSalesInstitutionErpCode(mdgVo.getVkorg());
            deliveryWay.setSalesInstitutionCode(salesOrgCode);
            salesOrgCode = salesOrgCode + mdgVo.getVkbur();
            deliveryWay.setSalesRegionErpCode(mdgVo.getVkbur());
            if (StringUtils.isNotBlank((CharSequence)mdgVo.getVkbur())) {
                deliveryWay.setSalesRegionCode(salesOrgCode);
            } else {
                deliveryWay.setSalesRegionCode("");
            }
            deliveryWay.setSalesOrgErpCode(mdgVo.getVkgrp());
            if (StringUtils.isNotBlank((CharSequence)mdgVo.getVkgrp()) && StringUtils.isNotBlank((CharSequence)mdgVo.getVkbur())) {
                deliveryWay.setSalesOrgCode(salesOrgCode + mdgVo.getVkgrp());
            } else {
                deliveryWay.setSalesRegionCode("");
            }
            deliveryWay.setHarvestAddress(mdgVo.getStras());
            deliveryWay.setHarvestContactPersons(mdgVo.getName());
            deliveryWay.setHarvestContactPhone(mdgVo.getTelf1());
            deliveryWay.setTenantCode(tenantCode);
            deliveryWay.setEnableStatus(enableStatus);
            deliveryWay.setDelFlag(delFlag);
            pullList.add(deliveryWay);
        });
        return pullList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getDeliveryWayCode())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DeliveryWay>(Comparator.comparing(DeliveryWay::getDeliveryWayCode))), ArrayList::new));
    }
}

