package com.biz.crm.mdm.business.party.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * (DeliveryWayDto)
 *
 * @author makejava
 * @since 2022-11-04 15:19:56
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DeliveryWayDto", description = "送达方管理")
public class DeliveryWayDto extends TenantFlagOpDto {
    /**
     * 送达方编码
     */
    @ApiModelProperty("送达方编码")
    private String deliveryWayCode;

    /**
     * 送达方名称
     */
    @ApiModelProperty("送达方名称")
    private String deliveryWayName;

    /**
     * 编码或名称
     */
    @ApiModelProperty("编码或名称")
    private String codeUnionName;

    /**
     * 送达方类型
     */
    @ApiModelProperty("送达方类型")
    private String typeName;

    /**
     * 送达方类型编码
     */
    @ApiModelProperty("送达方类型编码")
    private String typeCode;

    /**
     * 所属客户渠道
     */
    @ApiModelProperty("所属客户渠道")
    private String customerChannel;


    /**
     * 所属客户渠道编码
     */
    @ApiModelProperty("所属客户渠道编码")
    private String customerChannelCode;

    /**
     * 业态
     */
    @ApiModelProperty("业态")
    private String businessFormatCode;


    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgCode;


    @ApiModelProperty("所属销售组织(组)名称")
    private String salesOrgName;

    /**
     * 省
     */
    @ApiModelProperty("省")
    private String province;

    /**
     * 市
     */
    @ApiModelProperty("市")
    private String city;

    /**
     * 区
     */
    @ApiModelProperty("区")
    private String district;


    /**
     * 收获地址
     */
    @ApiModelProperty("收获地址")
    private String harvestAddress;

    /**
     * 收获联系人
     */
    @ApiModelProperty("收获联系人")
    private String harvestContactPersons;

    /**
     * 收获联系方式
     */
    @ApiModelProperty("收获联系人")
    private String harvestContactPhone;

    /**
     * 所属售达方编码
     */
    @ApiModelProperty("所属售达方编码")
    private String soldToPartyCode;

    /**
     * 所属售达方
     */
    @ApiModelProperty("所属售达方名称")
    private String soldToPartyName;

}
