package com.biz.crm.mdm.business.party.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.party.sdk.dto.DeliveryWayDto;
import com.biz.crm.mdm.business.party.sdk.dto.QueryDeliveryWayDto;
import com.biz.crm.mdm.business.party.sdk.dto.SubdueDto;
import com.biz.crm.mdm.business.party.sdk.vo.DeliveryWayVo;
import com.biz.crm.mdm.business.party.sdk.vo.QueryDeliveryWayVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * (DeliveryWayService)service 实现类
 * @author makejava
 * @since 2022-11-03 17:14:14
 */
public interface DeliveryWayService {
    /**
     * 分页查询数 据
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return
     */
    Page<DeliveryWayVo> findByConditions(Pageable pageable, DeliveryWayDto dto);


    /**
     * 送达方搜索接口
     *
     * @param dto 对象
     */
    DeliveryWayVo searchInterface(SubdueDto dto);

    /**
     * 根据送达方名称，通过送达方名称获取对应送达方编码
     *
     * @param deliveryWayName
     */
    String findByDeliveryWayCode(String deliveryWayName);

    /**
     * 根据送达方名称，通过送达方名称获取组织部门
     *
     * @param deliveryWayCode
     */
    String findBySalesOrganization(String deliveryWayCode);

    /**
     * 通过售达方所属编码和名称查询售达方编码和名称
     *
     * @param queryDeliveryWayDto 查询实体
     * @return 所有数据
     */
    List<QueryDeliveryWayVo> findByDeliveryWayDto(QueryDeliveryWayDto queryDeliveryWayDto);

    /**
     * 更新送达方
     *
     * @param deliveryWayDto 请求参数dto
     * @return 职位送达方
     */
    DeliveryWayVo update(DeliveryWayDto deliveryWayDto);

    /**
     * 通过ID获取送达方信息
     * @param id 送达方ID
     * @return 操作结果
     */
    DeliveryWayVo findById(String id);
}
