package com.biz.crm.mdm.business.price.form.local.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.price.form.sdk.dto.PriceFormDto;
import com.biz.crm.mdm.business.price.form.sdk.dto.TypePriceDataDto;
import com.biz.crm.mdm.business.price.form.sdk.service.PriceFormService;
import com.biz.crm.mdm.business.price.form.sdk.vo.PriceFormVo;
import com.biz.crm.mdm.business.price.form.sdk.vo.TypePriceDataVo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;

/**
 * (PriceFormController)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-08 12:05:57
 */
@RestController
@RequestMapping("/v1/priceForm/priceForm")
@Slf4j
@Api(tags = "产品主数据:PriceForm价格类型配置")
public class PriceFormController {

    @Autowired
    private PriceFormService priceFormService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/findByConditions")
    public Result<Page<PriceFormVo>> findByConditions(
        @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
        @ApiParam(name = "dto", value = "预算管理配置表") PriceFormDto dto) {
        try {
            Page<PriceFormVo> page = this.priceFormService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增价格类型
     *
     * @param typePriceDataDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "新增价格类型")
    @PostMapping
    public Result<?>
        create(@RequestBody @ApiParam(name = "typePriceDataDto", value = "价格类型主数据") TypePriceDataDto typePriceDataDto) {
        try {
            this.priceFormService.create(typePriceDataDto);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量删除
     */
    @ApiOperation(value = "批量删除")
    @DeleteMapping("/deleteBatch")
    public Result<?> delete(@RequestParam List<String> ids) {
        priceFormService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 更新价格类型
     *
     * @param dto 请求参数dto
     * @return 职位实体
     */
    @ApiOperation(value = "更新价格类型")
    @PatchMapping("/update")
    public Result<?> update(@RequestBody TypePriceDataDto dto) {
        try {
            this.priceFormService.update(dto);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 查详情
     */
    @ApiOperation(value = "根据主键id查询")
    @GetMapping("/findById")
    public Result<TypePriceDataVo> findById(@RequestParam String id) {
        try {
            TypePriceDataVo result = this.priceFormService.findById(id);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
