package com.biz.crm.mdm.business.price.form.local.entity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.persistence.Column;
import javax.persistence.Entity;
import java.util.Date;

/**
 * (PriceForm)
 *
 * @author makejava
 * @since 2022-11-05 12:00:01
 */
@ApiModel(value = "PriceForm", description = "价格类型")
@Data
@Entity(name = "mdm_price_form")
@org.hibernate.annotations.Table(appliesTo = "mdm_price_form", comment = "价格类型")
@TableName("mdm_price_form")
@EqualsAndHashCode(callSuper = false)
public class PriceForm extends TenantFlagOpEntity {

    /**
     * 价格类型编码
     */
    @ApiModelProperty("价格类型编码")
    @Column(name = "price_form_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '价格类型编码'")
    private String priceFormCode;

    /**
     * 价格类型名称
     */
    @ApiModelProperty("价格类型名称")
    @Column(name = "price_form_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '价格类型名称'")
    private String priceFormName;


    /**
     * 最近更新的人
     */
    @ApiModelProperty("最近更新的人")
    @Column(name = "current_update_people", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '最近更新的人'")
    private String currentUpdatePeople;


    /**
     * 最近更新的时间
     */
    @ApiModelProperty("创建时间")
    @Column(name = "current_update_date", nullable = true, length = -1, columnDefinition = "datetime COMMENT '最近更新的时间'")
    private Date currentUpdateDate;

}
