package com.biz.crm.mdm.business.price.form.local.entity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.persistence.Column;
import javax.persistence.Entity;

/**
 * (PricingDmension)
 * @author makejava
 * @since 2022-11-05 12:00:01
 */
@ApiModel(value = "PricingDmension", description = "定价维度配置表")
@Data
@Entity(name = "mdm_pricing_dimension")
@org.hibernate.annotations.Table(appliesTo = "mdm_pricing_dimension", comment = "定价维度配置表")
@TableName("mdm_pricing_dimension")
@EqualsAndHashCode(callSuper = false)
public class PricingDmension extends UuidFlagOpEntity {
    /**
     * 价格类型编码
     */
    @ApiModelProperty("价格类型编码")
    @Column(name = "price_form_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '价格类型编码'")
    private String priceFormCode;

    /**
     * 定价维度
     */
    @ApiModelProperty("定价维度")
    @Column(name = "pricing_dimension", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '定价维度'")
    private String pricingDimension;

}
