package com.biz.crm.mdm.business.price.form.local.mapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.price.form.local.entity.PriceForm;
import com.biz.crm.mdm.business.price.form.sdk.dto.PriceFormDto;
import com.biz.crm.mdm.business.price.form.sdk.vo.PriceFormVo;
import org.apache.ibatis.annotations.Param;

/**
 * 价格类型的mybatis-plus接口类 {@link PriceForm}
 *
 * @Author YangWei
 * @Date 2022/2/28 下午3:58
 */
public interface PriceFormMapper extends BaseMapper<PriceForm> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param priceFormDto  查询实体
     * @return 所有数据
     */
    Page<PriceFormVo> findByConditions(Page<PriceFormVo> page, @Param("priceFormDto") PriceFormDto priceFormDto);

    /**
     * 通过价格类型编码查询用户数据
     */
    PriceForm findByPriceFormCode(String priceFormCode);


    /**
     * 通过价格类型编码查询用户数据
     */
    PriceForm findByCodeData(String priceFormCode);
}
