package com.biz.crm.mdm.business.price.form.local.notifier;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.price.form.sdk.dto.PriceFormDto;
import com.biz.crm.mdm.business.price.form.sdk.dto.PriceFormLogEventDto;
import com.biz.crm.mdm.business.price.form.sdk.event.log.PriceFormLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年06月23日 15:47:00
 */

@Component
public class PriceFormLogEventListenerImpl implements PriceFormLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    @Override
    public void onCreate(PriceFormLogEventDto eventDto) {
        PriceFormDto newest = eventDto.getNewest();
        PriceFormDto original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        //设置操作类型
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        //设置唯一键键
        crmBusinessLogDto.setOnlyKey(onlyKey);
        //设置租户代码
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //设置旧对象
        crmBusinessLogDto.setOldObject(original);
        //设置新对象
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);

    }

    @Override
    public void onDelete(PriceFormLogEventDto eventDto) {
        PriceFormDto newest = eventDto.getNewest();
        PriceFormDto original = eventDto.getOriginal();
        //设置主键ID
        String onlyKey = original.getId();
        //业务日志
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        //类型代码
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        //设置唯一键键
        crmBusinessLogDto.setOnlyKey(onlyKey);
        //租户代码
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //设置旧对象
        crmBusinessLogDto.setOldObject(original);
        //设置新对象
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onUpdate(PriceFormLogEventDto eventDto) {
        PriceFormDto newest = eventDto.getNewest();
        //获取原始值
        PriceFormDto original = eventDto.getOriginal();
        //主键ID
        String onlyKey = original.getId();
        //业务日志
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        //类型代码
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        //设置唯一键键
        crmBusinessLogDto.setOnlyKey(onlyKey);
        //租户代码
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //设置旧对象
        crmBusinessLogDto.setOldObject(original);
        //设置新对象
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onUpdateEnable(PriceFormLogEventDto eventDto) {
        //获取最新的
        PriceFormDto newest = eventDto.getNewest();
        //获取原始值
        PriceFormDto original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只传单个字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", original.getEnableStatus());
        newObject.put("enableStatus", newest.getEnableStatus());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
