package com.biz.crm.mdm.business.price.form.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.price.form.local.entity.PriceForm;
import com.biz.crm.mdm.business.price.form.local.entity.PricingDmension;
import com.biz.crm.mdm.business.price.form.local.mapper.PriceFormMapper;
import com.biz.crm.mdm.business.price.form.sdk.dto.PriceFormDto;
import com.biz.crm.mdm.business.price.form.sdk.vo.PriceFormVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * (PriceFormRepository)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-14 17:06:39
 */
@Component
public class PriceFormRepository extends ServiceImpl<PriceFormMapper, PriceForm> {

    @Autowired
    private PriceFormMapper priceFormMapper;

    @Autowired
    private PricingDmensionRepository pricingDmensionRepository;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return
     */
    public Page<PriceFormVo> findByConditions(Pageable pageable, PriceFormDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of(0, 50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<PriceFormVo> page = new Page<PriceFormVo>(pageable.getPageNumber(), pageable.getPageSize());
        return priceFormMapper.findByConditions(page, dto);
    }

    /**
     * 通过价格类型编码查询用户数据
     */
    public PriceForm findByPriceFormCode(String priceFormCode) {
        return this.lambdaQuery().eq(PriceForm::getPriceFormCode, priceFormCode).one();
    }

    /**
     * 通过价格类型编码查询用户数据
     */
    public PriceForm findByCodeData(String priceFormCode) {
        return this.priceFormMapper.findByCodeData(priceFormCode);
    }

    /**
     * 通过价格类型名查询价格详情
     */
    public PriceForm findByPriceDetails(String priceFormName) {
        return this.lambdaQuery().eq(PriceForm::getPriceFormName, priceFormName).one();
    }

    /**
     * 根据主键集合，修改 del_flag
     *
     * @param delFlagStatusEnum 删除标记
     * @param ids               主键id集合
     */
    public void updateDelStatusByIdIn(DelFlagStatusEnum delFlagStatusEnum, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.lambdaUpdate().in(PriceForm::getId, ids)
                .set(PriceForm::getDelFlag, delFlagStatusEnum.getCode())
                .eq(PriceForm::getTenantCode, TenantUtils.getTenantCode()) // 过滤多租户
                .update();
    }

    /**
     * 重构查询方法
     *
     * @param id
     * @param tenantCode
     * @return
     */
    public PriceForm findByIdAndTenantCode(String id, String tenantCode) {
        return this.lambdaQuery()
                .eq(PriceForm::getTenantCode, tenantCode)
                .in(PriceForm::getId, id)
                .one();
    }


    /**
     * 删除定价维度
     */
    public void deleteByControlsById(String controlsById) {
        if (StringUtils.isEmpty(controlsById)) {
            return;
        }
        PriceForm priceForm = this.getById(controlsById);
        if (ObjectUtils.isEmpty(priceForm)) {
            throw new RuntimeException("来源数据数据不存在！");
        }
        //根据type_coding查询字段
        List<PricingDmension> result1 = pricingDmensionRepository.getByPriceFormCode(priceForm.getPriceFormCode());
        if (!CollectionUtils.isEmpty(result1)) {
            result1.forEach(r1 -> {
                r1.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.pricingDmensionRepository.updateBatchById(result1);
        }
    }
}
