package com.biz.crm.mdm.business.price.form.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.price.form.local.entity.PricingDmension;
import com.biz.crm.mdm.business.price.form.local.mapper.PricingDmensionMapper;
import com.biz.crm.mdm.business.price.form.sdk.dto.PricingDmensionDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * (PricingDmensionRepository)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-14 17:06:39
 */
@Component
public class PricingDmensionRepository extends ServiceImpl<PricingDmensionMapper, PricingDmension> {

    @Autowired
    private PricingDmensionMapper pricingDmensionMapper;


    /**
     * 通过价格类型编码定价维度
     */
    public List<PricingDmension> findByPricingDimension(String priceFormCode) {
        return this.lambdaQuery().eq(PricingDmension::getPriceFormCode, priceFormCode).list();
    }

    /**
     * 根据编码类型删除选择预算项目
     */
    public void deleteByControlsConfigCode(String priceFormCode) {
        if (StringUtils.isEmpty(priceFormCode)) {
            return;
        }
        List<PricingDmension> list = this.lambdaQuery().eq(PricingDmension::getPriceFormCode, priceFormCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(pricingDmension -> {
                pricingDmension.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    public List<PricingDmension> findByIdAnddelFlagde(String priceFormCode, String delFlag) {
        if (StringUtils.isEmpty(delFlag)) {
            return null;
        }
        return this.lambdaQuery().eq(PricingDmension::getPriceFormCode, priceFormCode).eq(PricingDmension::getDelFlag, delFlag).list();
    }

    /**
     * 查询集合*/
    public List<PricingDmension> getByPriceFormCode(String priceFormCode) {
        return this.lambdaQuery().eq(PricingDmension::getPriceFormCode, priceFormCode).list();
    }
}
