package com.biz.crm.mdm.business.price.form.local.service.impl;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.price.form.local.entity.PricingDmension;
import com.biz.crm.mdm.business.price.form.local.repository.PricingDmensionRepository;
import com.biz.crm.mdm.business.price.form.local.util.ListConverterUtils;
import com.biz.crm.mdm.business.price.form.sdk.dto.PricingDmensionDto;
import com.biz.crm.mdm.business.price.form.sdk.service.PricingDmensionService;
import com.biz.crm.mdm.business.price.form.sdk.vo.PricingDmensionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * (PricingDmensionServiceImpl)表服务实现类
 *
 * @author makejava
 * @since 2022-11-03 17:06:02
 */
@Slf4j
@Service("pricingDmensionService")
public class PricingDmensionServiceImpl implements PricingDmensionService {

    @Autowired
    private PricingDmensionRepository pricingDmensionRepository;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;


    /**
     * 保存副表定价维度配置表数据
     */
    @Override
    public void sava(PricingDmensionDto pricingDmensionDto, String promotionCode) {
        //通过价格类型编码查询定价维度配置
        List<PricingDmension> pricingDmension = this.pricingDmensionRepository.getByPriceFormCode(pricingDmensionDto.getPriceFormCode());
//        if (pricingDmension != null) {
//            throw new RuntimeException("数不为空");
//        }
        pricingDmensionDto.setPriceFormCode(promotionCode);
        pricingDmensionDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        pricingDmensionDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        //保存主表价格类型字段
        PricingDmension pricingDmension1 = this.nebulaToolkitService.copyObjectByWhiteList(pricingDmensionDto,
                PricingDmension.class,
                HashSet.class,
                ArrayList.class);
        pricingDmensionRepository.save(pricingDmension1);
    }


    /**
     * 更新定价维度配置表
     */
    @Override
    public PricingDmensionVo update(PricingDmensionDto dto) {
        List<PricingDmensionVo> result = this.findByPricingDimension(dto.getPriceFormCode());
        Validate.notNull(result, "定价维度数据不存在");
        PricingDmension pricingDmension1 = this.nebulaToolkitService.copyObjectByWhiteList(dto,
                PricingDmension.class,
                HashSet.class,
                ArrayList.class);
        pricingDmensionRepository.saveOrUpdate(pricingDmension1);
        PricingDmensionVo vo = this.nebulaToolkitService.copyObjectByWhiteList(dto,
                PricingDmensionVo.class,
                HashSet.class,
                ArrayList.class);
        return vo;
    }

    /**
     * 通过价格类型编码定价维度
     */
    @Override
    public List<PricingDmensionVo> findByPricingDimension(String priceFormCode) {
        List<PricingDmension> pricingDmension = this.pricingDmensionRepository.findByPricingDimension(priceFormCode);
        Validate.notNull(pricingDmension, "定价维度数据不存在");
        // 将List<User>转List<UserDto>
        ListConverterUtils converterUtils = new ListConverterUtils(PricingDmensionVo.class);
        List<PricingDmensionVo> arrayList = converterUtils.converterList(pricingDmension);
        return arrayList;
    }

    /**
     * 根据编码类型删除选择预算项目
     */
    @Override
    public void deleteByControlsConfigCode(String priceFormCode) {
        this.pricingDmensionRepository.deleteByControlsConfigCode(priceFormCode);
    }

    /**
     * 批量新定价维度配置表
     */
    @Override
    public void savaBatch(List<PricingDmensionDto> dto) {
        for (PricingDmensionDto d : dto) {
            d.setId(null);
        }
        if (dto != null && dto.size() > 0) {
            ArrayList<PricingDmension> result =
                    Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(dto, PricingDmensionDto.class, PricingDmension.class, HashSet.class, ArrayList.class));
            pricingDmensionRepository.saveOrUpdateBatch(result);
        }

    }

    /**
     * 副表查询
     */
    @Override
    public List<PricingDmensionVo> findByIdAnddelFlagde(String priceFormCode, String delFlag) {
        List<PricingDmension> result = this.pricingDmensionRepository.findByIdAnddelFlagde(priceFormCode, delFlag);
        ListConverterUtils converterUtils = new ListConverterUtils(PricingDmensionVo.class);
        List<PricingDmensionVo> arrayList = converterUtils.converterList(result);
        return arrayList;
    }
}

