/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.form.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.price.form.local.entity.PriceForm;
import com.biz.crm.mdm.business.price.form.local.entity.PricingDmension;
import com.biz.crm.mdm.business.price.form.local.mapper.PriceFormMapper;
import com.biz.crm.mdm.business.price.form.local.repository.PricingDmensionRepository;
import com.biz.crm.mdm.business.price.form.sdk.dto.PriceFormDto;
import com.biz.crm.mdm.business.price.form.sdk.vo.PriceFormVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PriceFormRepository
extends ServiceImpl<PriceFormMapper, PriceForm> {
    @Autowired
    private PriceFormMapper priceFormMapper;
    @Autowired
    private PricingDmensionRepository pricingDmensionRepository;

    public Page<PriceFormVo> findByConditions(Pageable pageable, PriceFormDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.priceFormMapper.findByConditions((Page<PriceFormVo>)page, dto);
    }

    public PriceForm findByPriceFormCode(String priceFormCode) {
        return (PriceForm)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PriceForm::getPriceFormCode, (Object)priceFormCode)).one());
    }

    public PriceForm findByCodeData(String priceFormCode) {
        return this.priceFormMapper.findByCodeData(priceFormCode);
    }

    public PriceForm findByPriceDetails(String priceFormName) {
        return (PriceForm)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PriceForm::getPriceFormName, (Object)priceFormName)).one());
    }

    public void updateDelStatusByIdIn(DelFlagStatusEnum delFlagStatusEnum, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)delFlagStatusEnum.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public PriceForm findByIdAndTenantCode(String id, String tenantCode) {
        return (PriceForm)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void deleteByControlsById(String controlsById) {
        if (StringUtils.isEmpty((CharSequence)controlsById)) {
            return;
        }
        PriceForm priceForm = (PriceForm)((Object)this.getById((Serializable)((Object)controlsById)));
        if (ObjectUtils.isEmpty((Object)((Object)priceForm))) {
            throw new RuntimeException("\u6765\u6e90\u6570\u636e\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        List<PricingDmension> result1 = this.pricingDmensionRepository.getByPriceFormCode(priceForm.getPriceFormCode());
        if (!CollectionUtils.isEmpty(result1)) {
            result1.forEach(r1 -> r1.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.pricingDmensionRepository.updateBatchById(result1);
        }
    }
}

