/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.form.local.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.price.form.local.entity.PriceForm;
import com.biz.crm.mdm.business.price.form.local.repository.PriceFormRepository;
import com.biz.crm.mdm.business.price.form.sdk.dto.PriceFormDto;
import com.biz.crm.mdm.business.price.form.sdk.dto.PriceFormLogEventDto;
import com.biz.crm.mdm.business.price.form.sdk.dto.PricingDmensionDto;
import com.biz.crm.mdm.business.price.form.sdk.dto.TypePriceDataDto;
import com.biz.crm.mdm.business.price.form.sdk.enmus.PricingDimensionEnum;
import com.biz.crm.mdm.business.price.form.sdk.event.log.PriceFormLogEventListener;
import com.biz.crm.mdm.business.price.form.sdk.service.PriceFormService;
import com.biz.crm.mdm.business.price.form.sdk.service.PricingDmensionService;
import com.biz.crm.mdm.business.price.form.sdk.vo.PriceFormVo;
import com.biz.crm.mdm.business.price.form.sdk.vo.PriceManagementDataVo;
import com.biz.crm.mdm.business.price.form.sdk.vo.PriceManagementVo;
import com.biz.crm.mdm.business.price.form.sdk.vo.PricingDimensionVo;
import com.biz.crm.mdm.business.price.form.sdk.vo.PricingDmensionVo;
import com.biz.crm.mdm.business.price.form.sdk.vo.TypePriceDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="priceFormService")
public class PriceFormServiceImpl
implements PriceFormService {
    private static final Logger log = LoggerFactory.getLogger(PriceFormServiceImpl.class);
    @Autowired
    private PriceFormRepository priceFormRepository;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private PricingDmensionService pricingDmensionService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public Page<PriceFormVo> findByConditions(Pageable pageable, PriceFormDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new PriceFormDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.priceFormRepository.findByConditions(pageable, dto);
    }

    public void create(TypePriceDataDto dto) {
        Date nowDate = new Date();
        PriceFormDto priceFormDto = dto.getPriceFormDto();
        List pricingDmensionDto = dto.getPricingDmensionDto();
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)priceFormDto.getPriceFormName()), (String)"\u4ef7\u683c\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((priceFormDto.getPriceFormName().length() < 128 ? 1 : 0) != 0, (String)"\u4ef7\u683c\u7c7b\u578b\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u8f93\u5165\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        PriceForm priceForm = this.priceFormRepository.findByPriceFormCode(priceFormDto.getPriceFormCode());
        Validate.isTrue((boolean)Objects.isNull((Object)priceForm), (String)"\u5df2\u5b58\u5728\u5f53\u524d\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\u7684\u6570\u636e", (Object[])new Object[0]);
        priceFormDto.setTenantCode(TenantUtils.getTenantCode());
        priceFormDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        priceFormDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        priceFormDto.setCreateName(this.loginUserService.getLoginAccountName());
        priceFormDto.setCreateTime(nowDate);
        String ruleCode = "zp";
        String promotionCode = (String)this.generateCodeService.generateCode(ruleCode, 1).get(0);
        priceFormDto.setPriceFormCode(promotionCode);
        PriceForm priceForm1 = (PriceForm)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)priceFormDto, PriceForm.class, HashSet.class, ArrayList.class, new String[0]));
        this.priceFormRepository.save((Object)priceForm1);
        for (PricingDmensionDto dmensionDto : pricingDmensionDto) {
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dmensionDto.getPricingDimension()), (String)"\u5b9a\u4ef7\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            this.pricingDmensionService.sava(dmensionDto, promotionCode);
        }
        PriceFormLogEventDto logEventDto = new PriceFormLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(priceFormDto);
        SerializableBiConsumer & Serializable onCreate = PriceFormLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceFormLogEventListener.class, (SerializableBiConsumer)onCreate);
    }

    public void update(TypePriceDataDto dto) {
        Date date = new Date();
        this.updateValidation(dto);
        PriceFormDto priceFormDto = dto.getPriceFormDto();
        PriceForm byPriceFormCode = this.priceFormRepository.findByPriceFormCode(priceFormDto.getPriceFormCode());
        Validate.notNull((Object)((Object)byPriceFormCode), (String)"\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        priceFormDto.setCurrentUpdatePeople(this.loginUserService.getLoginAccountName());
        priceFormDto.setCurrentUpdateDate(date);
        PriceForm priceForm = (PriceForm)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)priceFormDto, PriceForm.class, HashSet.class, ArrayList.class, new String[0]));
        this.priceFormRepository.saveOrUpdate((Object)priceForm);
        this.pricingDmensionService.deleteByControlsConfigCode(priceFormDto.getPriceFormCode());
        this.pricingDmensionService.savaBatch(dto.getPricingDmensionDto());
    }

    private void updateValidation(TypePriceDataDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        PriceFormDto priceFormDto = dto.getPriceFormDto();
        priceFormDto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)priceFormDto.getPriceFormName(), (String)"\u4ef7\u683c\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)priceFormDto.getPriceFormName()) || priceFormDto.getPriceFormName().length() < 128 ? 1 : 0) != 0, (String)"\u4ef7\u683c\u7c7b\u578b\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        List listDto = dto.getPricingDmensionDto();
        listDto.forEach(l -> Validate.notBlank((CharSequence)l.getPricingDimension(), (String)"\u5b9a\u4ef7\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]));
    }

    public PriceManagementVo findByPriceFormName(String priceFormName) {
        ArrayList<PricingDimensionVo> arrayList = new ArrayList<PricingDimensionVo>();
        Validate.notBlank((CharSequence)priceFormName, (String)"\u4ef7\u683c\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((priceFormName.length() < 255 ? 1 : 0) != 0, (String)"\u4ef7\u683c\u7c7b\u578b\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        PriceForm priceForm = this.priceFormRepository.findByPriceDetails(priceFormName);
        PriceFormVo priceFormVo = (PriceFormVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)priceForm, PriceFormVo.class, HashSet.class, ArrayList.class, new String[0]);
        Validate.notNull((Object)((Object)priceForm), (String)"\u5f53\u524d\u4ef7\u683c\u7c7b\u578b\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List pricingDmensionVo = this.pricingDmensionService.findByPricingDimension(priceForm.getPriceFormCode());
        Validate.notNull((Object)((Object)priceForm), (String)"\u67e5\u8be2\u51fa\u6765\u7684\u5b9a\u4ef7\u7ef4\u5ea6\u914d\u7f6e\u4f53\u8868\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        for (PricingDmensionVo pricingDmensionVos : pricingDmensionVo) {
            String pricingDimension = pricingDmensionVos.getPricingDimension();
            String[] split = pricingDimension.split(",");
            String result = "";
            for (String s : split) {
                if (s.equals(PricingDimensionEnum.CHANNEL.getPriceFormCode())) {
                    result = result + "/" + PricingDimensionEnum.CHANNEL.getPriceFormName();
                    continue;
                }
                if (s.equals(PricingDimensionEnum.CUSTOMER.getPriceFormCode())) {
                    result = result + "/" + PricingDimensionEnum.CUSTOMER.getPriceFormName();
                    continue;
                }
                if (s.equals(PricingDimensionEnum.PRODUCT.getPriceFormCode())) {
                    result = result + "/" + PricingDimensionEnum.PRODUCT.getPriceFormName();
                    continue;
                }
                if (s.equals(PricingDimensionEnum.MARKETING_ORGANIZING.getPriceFormCode())) {
                    result = result + "/" + PricingDimensionEnum.MARKETING_ORGANIZING.getPriceFormName();
                    continue;
                }
                if (s.equals(PricingDimensionEnum.ORG.getPriceFormCode())) {
                    result = result + "/" + PricingDimensionEnum.ORG.getPriceFormName();
                    continue;
                }
                if (s.equals(PricingDimensionEnum.PRICE_GROUP.getPriceFormCode())) {
                    result = result + "/" + PricingDimensionEnum.PRICE_GROUP.getPriceFormName();
                    continue;
                }
                if (!s.equals(PricingDimensionEnum.TERMINAL.getPriceFormCode())) continue;
                result = result + "/" + PricingDimensionEnum.TERMINAL.getPriceFormName();
            }
            PricingDimensionVo dimensionVo = new PricingDimensionVo(pricingDimension, result);
            arrayList.add(dimensionVo);
        }
        return new PriceManagementVo(priceFormVo, arrayList);
    }

    @Transactional
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01");
        }
        List dimensionControls = this.priceFormRepository.listByIds(ids);
        if (!CollectionUtils.isEmpty((Collection)dimensionControls)) {
            dimensionControls.forEach(priceForm -> priceForm.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.priceFormRepository.updateBatchById(dimensionControls);
            ids.forEach(controlsById -> this.priceFormRepository.deleteByControlsById((String)controlsById));
        }
        List<PriceFormVo> priceFormVos = this.findByIds(ids);
        Collection dimensionBudgetDtos = this.nebulaToolkitService.copyCollectionByWhiteList(priceFormVos, PriceFormVo.class, PriceFormDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = PriceFormLogEventListener::onDelete;
        for (PriceFormDto dimensionControlsDto : dimensionBudgetDtos) {
            PriceFormLogEventDto logEventDto = new PriceFormLogEventDto();
            logEventDto.setOriginal(dimensionControlsDto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceFormLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    public TypePriceDataVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        PriceForm result = this.priceFormRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        PriceFormVo priceFormVo = (PriceFormVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)result, PriceFormVo.class, HashSet.class, ArrayList.class, new String[0]);
        List vo = this.pricingDmensionService.findByIdAnddelFlagde(result.getPriceFormCode(), result.getDelFlag());
        return new TypePriceDataVo(priceFormVo, vo);
    }

    public PriceManagementDataVo findByPriceManagementData(String priceFormCode) {
        ArrayList<String> list = new ArrayList<String>();
        Validate.notBlank((CharSequence)priceFormCode, (String)"\u4ef7\u683c\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PriceForm priceForm = this.priceFormRepository.findByCodeData(priceFormCode);
        Validate.notNull((Object)((Object)priceForm), (String)"\u5f53\u524d\u4ef7\u683c\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List pricingDmensionVo = this.pricingDmensionService.findByPricingDimension(priceForm.getPriceFormCode());
        Validate.notNull((Object)pricingDmensionVo, (String)"\u67e5\u8be2\u51fa\u6765\u7684\u5b9a\u4ef7\u7ef4\u5ea6\u914d\u7f6e\u8868\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        for (PricingDmensionVo dmensionVo : pricingDmensionVo) {
            list.add(dmensionVo.getPricingDimension());
        }
        return new PriceManagementDataVo(priceForm.getPriceFormCode(), list, priceForm.getPriceFormName());
    }

    private List<PriceFormVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List priceForms = this.priceFormRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)priceForms)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)priceForms, PriceForm.class, PriceFormVo.class, HashSet.class, ArrayList.class, new String[0]));
    }
}

