package com.biz.crm.mdm.business.price.form.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.Date;

/**
 * (PricingDmensionDto)
 * @author makejava
 * @since 2022-11-04 15:19:51
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "PriceForm", description = "价格类型置表")
public class PriceFormDto extends TenantFlagOpDto {

    /**
     * 价格类型编码
     */
    @ApiModelProperty("价格类型编码")
    @Column(name = "price_form_code", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '价格类型编码'")
    private String priceFormCode;

    /**
     * 价格类型名称
     */
    @ApiModelProperty("价格类型名称")
    @Column(name = "price_form_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '价格类型名称'")
    private String priceFormName;

    /**
     * 最近更新的人
     */
    @ApiModelProperty("最近更新的人")
    @Column(name = "current_update_people", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '最近更新的人'")
    private String currentUpdatePeople;


    /**
     * 最近更新的时间
     */
    @ApiModelProperty("创建时间")
    @Column(name = "current_update_date", nullable = true, length = -1, columnDefinition = "datetime COMMENT '最近更新的时间'")
    private Date currentUpdateDate;

}
