package com.biz.crm.mdm.business.price.form.sdk.dto;

import com.biz.crm.business.common.sdk.dto.UuidFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * (PricingDmensionDto)
 * @author makejava
 * @since 2022-11-04 15:19:51
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "PricingDmension", description = "定价维度配置表")
public class PricingDmensionDto extends UuidFlagOpDto {
    /**
     * 价格类型编码
     */
    @ApiModelProperty("价格类型编码")
    @Column(name = "price_form_code", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '价格类型编码'")
    private String priceFormCode;

    /**
     * 定价维度
     */
    @ApiModelProperty("定价维度")
    @Column(name = "pricing_dimension", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '定价维度'")
    private String pricingDimension;
}
