package com.biz.crm.mdm.business.price.form.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.price.form.sdk.dto.PriceFormDto;
import com.biz.crm.mdm.business.price.form.sdk.dto.TypePriceDataDto;
import com.biz.crm.mdm.business.price.form.sdk.vo.PriceFormVo;
import com.biz.crm.mdm.business.price.form.sdk.vo.PriceManagementDataVo;
import com.biz.crm.mdm.business.price.form.sdk.vo.PriceManagementVo;
import com.biz.crm.mdm.business.price.form.sdk.vo.TypePriceDataVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * (PriceFormService)service实现类
 *
 * @author makejava
 * @since 2022-11-14 17:14:14
 */
public interface PriceFormService {

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    Page<PriceFormVo> findByConditions(Pageable pageable, PriceFormDto dto);

    /**
     * 新增价格类型
     *
     * @param typePriceDataDto 查询实体
     * @return 所有数据
     */
    void create(TypePriceDataDto typePriceDataDto);

    /**
     * 更新价格类型
     *
     * @param dto 请求参数dto
     * @return 职位实体
     */
    void update(TypePriceDataDto dto);

    /**
     * 通过价格类型名查询价格详情
     */
    PriceManagementVo findByPriceFormName(String priceFormName);

    /**
     * 批量删除
     */
    void deleteBatch(List<String> ids);

    /**
     * 查详情
     */
    TypePriceDataVo findById(String id);


    /**
     * 通过价格类型名称查询价格详情
     * @param priceFormCode 请求参数
     * @return 价格类型详情
     */
    PriceManagementDataVo findByPriceManagementData(String priceFormCode);
}
