package com.biz.crm.mdm.business.price.management.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.price.form.sdk.vo.PriceFormVo;
import com.biz.crm.mdm.business.price.form.sdk.vo.TypePriceDataVo;
import com.biz.crm.mdm.business.price.management.sdk.dto.PriceDirectDataDto;
import com.biz.crm.mdm.business.price.management.sdk.service.PriceManagementService;
import com.biz.crm.mdm.business.price.management.sdk.vo.PriceDirectDataEventVo;
import com.biz.crm.mdm.business.price.management.sdk.vo.PriceDirectDataVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * (PriceManagementController)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-08 12:05:59
 */
@RestController
@RequestMapping("/v1/priceManagement/priceManagement")
@Slf4j
@Api(tags = "产品主数据:PriceManagement价格管理配置")
public class PriceManagementController {

    @Autowired
    private PriceManagementService priceManagementService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/findByConditions")
    public Result<Page<PriceDirectDataVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                            @ApiParam(name = "dto", value = "预算管理配置表") PriceDirectDataDto dto) {
        try {
            Page<PriceDirectDataVo> page = this.priceManagementService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增价格管理
     *
     * @param priceDirectDataDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "新增价格管理")
    @PostMapping
    public Result<PriceDirectDataVo> create(
            @RequestBody @ApiParam(name = "priceDirectDataDto", value = "价格管理主数据") PriceDirectDataDto priceDirectDataDto) {
        try {
            PriceDirectDataVo priceDirectDataVo = this.priceManagementService.create(priceDirectDataDto);
            return Result.ok(priceDirectDataVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新价格管理
     *
     * @param dto 请求参数dto
     * @return 职位实体
     */
    @ApiOperation(value = "更新价格管理")
    @PatchMapping("/update")
    public Result<String> update(@RequestBody PriceDirectDataDto dto) {
        try {
            String update = this.priceManagementService.update(dto);
            return (Result<String>) Result.ok(update);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量启用
     */

    @ApiOperation(value = "批量启用")
    @PatchMapping("/enableBatch")
    public Result<?> enable(@RequestBody List<String> ids) {
        priceManagementService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 批量禁用
     */
    @ApiOperation(value = "批量禁用")
    @PatchMapping("/disableBatch")
    public Result<?> disable(@RequestBody List<String> ids) {
        priceManagementService.disableBatch(ids);
        return Result.ok("禁用成功");
    }


    /**
     * 根据定价记录号，通过产品编码获取对价格管理基本信息
     *
     * @param pricingRecordNumber
     */
    @ApiOperation(value = " 根据产品编码，通过产品编码获取对产品管理基本信息")
    @GetMapping
    public Result<PriceDirectDataVo> listByProductCode(@RequestParam("pricingRecordNumber") String pricingRecordNumber) {
        try {
            PriceDirectDataVo result = this.priceManagementService.listByPricingRecordNumber(pricingRecordNumber);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 查详情
     */
    @ApiOperation(value = "根据主键id查详情")
    @GetMapping("/findById")
    public Result<PriceDirectDataVo> findById(@RequestParam String id) {
        try {
            PriceDirectDataVo result = this.priceManagementService.findById(id);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
