package com.biz.crm.mdm.business.price.management.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.math.BigDecimal;
import java.util.Date;

/**
 * (PriceDirectData)
 *
 * @author makejava
 * @since 2022-11-05 12:00:01
 */
@ApiModel(value = "PriceDirectData", description = "价格管理")
@Data
@Entity(name = "mdm_price_data")
@org.hibernate.annotations.Table(appliesTo = "mdm_price_data", comment = "价格管理")
@TableName("mdm_price_data")
@EqualsAndHashCode(callSuper = true)
public class PriceDirectData extends TenantFlagOpEntity {

    /**
     * 定价记录号
     */
    @ApiModelProperty("定价记录号")
    @Column(name = "pricing_record_number", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '定价记录号'")
    private String pricingRecordNumber;

    /**
     * 价格类型编码
     */
    @ApiModelProperty("价格类型编码")
    @Column(name = "price_form_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '价格类型编码'")
    private String priceFormCode;


    /**
     * 价格类型名称
     */
    @ApiModelProperty("价格类型名称")
    @Column(name = "price_form_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '价格类型名称'")
    private String priceFormName;

    /**
     * 定价维度
     */
    @ApiModelProperty("定价维度")
    @Column(name = "pricing_dimension", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '定价维度'")
    private String pricingDimension;


    /**
     * 商品编码
     */
    @ApiModelProperty("商品编码")
    @Column(name = "goods_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '商品编码'")
    private String goodsCode;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    @Column(name = "goods_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '商品名称'")
    private String goodsName;

    /**
     * 价格
     */
    @ApiModelProperty("价格")
    @Column(name = "price", nullable = true, length = 10, columnDefinition = "decimal(10,6) COMMENT '价格'")
    private BigDecimal price;


    /**
     * 有效开始时间
     */
    @ApiModelProperty(name = "有效开始时间", notes = "有效开始时间")
    @Column(name = "start_time", nullable = true, columnDefinition = "DATETIME COMMENT '有效开始时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;
    /**
     * 有效结束时间
     */
    @ApiModelProperty(name = "有效结束时间", notes = "有效结束时间")
    @Column(name = "end_time", nullable = true, columnDefinition = "DATETIME COMMENT '有效结束时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;


    /**
     * 组织
     */
    @ApiModelProperty("组织")
    @Column(name = "organization", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '组织'")
    private String organization;

    /**
     * 客户
     */
    @ApiModelProperty("客户")
    @Column(name = "client", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '客户'")
    private String client;


    /**
     * 生效状态
     */
    @ApiModelProperty("生效状态")
    @Column(name = "validState", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '生效状态'")
    private String validState;

}
