package com.biz.crm.mdm.business.price.management.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.price.management.local.entity.PriceDirectData;
import com.biz.crm.mdm.business.price.management.sdk.dto.PriceDirectDataDto;
import com.biz.crm.mdm.business.price.management.sdk.vo.PriceDirectDataVo;
import org.apache.ibatis.annotations.Param;

/**
 * 价格管理的mybatis-plus接口类 {@link PriceDirectData}
 *
 * @Author YangWei
 * @Date 2022/11/19 下午12:58
 */

public interface PriceManagementMapper extends BaseMapper<PriceDirectData> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  查询实体
     * @return 所有数据
     */
    Page<PriceDirectDataVo> findByConditions(Page<PriceDirectDataVo> page, @Param("dto") PriceDirectDataDto dto);


    /**
     * 查找上一次更新价格
     */
    PriceDirectDataVo getByPriceUpdatedLastTime(String pricingDimension);

}
