package com.biz.crm.mdm.business.price.management.local.notifier;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.price.management.sdk.dto.PriceDirectDataDto;
import com.biz.crm.mdm.business.price.management.sdk.dto.PriceDirectDataLogEventDto;
import com.biz.crm.mdm.business.price.management.sdk.event.log.PriceDirectLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年11月23日 15:47:00
 */
@Component
public class PriceDirectDataLogEventListenerImpl implements PriceDirectLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    @Override
    public void onCreate(PriceDirectDataLogEventDto eventDto) {
        PriceDirectDataDto newest = eventDto.getNewest();
        PriceDirectDataDto original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        //设置操作类型
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        //设置唯一键键
        crmBusinessLogDto.setOnlyKey(onlyKey);
        //设置租户代码
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //设置旧对象
        crmBusinessLogDto.setOldObject(original);
        //设置新对象
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);

    }

    @Override
    public void onDelete(PriceDirectDataLogEventDto eventDto) {
        PriceDirectDataDto newest = eventDto.getNewest();
        PriceDirectDataDto original = eventDto.getOriginal();
        //设置主键ID
        String onlyKey = original.getId();
        //业务日志
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        //类型代码
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        //设置唯一键键
        crmBusinessLogDto.setOnlyKey(onlyKey);
        //租户代码
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //设置旧对象
        crmBusinessLogDto.setOldObject(original);
        //设置新对象
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onUpdate(PriceDirectDataLogEventDto eventDto) {
        PriceDirectDataDto newest = eventDto.getNewest();
        //获取原始值
        PriceDirectDataDto original = eventDto.getOriginal();
        //主键ID
        String onlyKey = original.getId();
        //业务日志
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        //类型代码
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        //设置唯一键键
        crmBusinessLogDto.setOnlyKey(onlyKey);
        //租户代码
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //设置旧对象
        crmBusinessLogDto.setOldObject(original);
        //设置新对象
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onUpdateEnable(PriceDirectDataLogEventDto eventDto) {
        //获取最新的
        PriceDirectDataDto newest = eventDto.getNewest();
        //获取原始值
        PriceDirectDataDto original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只传单个字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", original.getEnableStatus());
        newObject.put("enableStatus", newest.getEnableStatus());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
