package com.biz.crm.mdm.business.price.management.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.price.form.sdk.service.PriceFormService;
import com.biz.crm.mdm.business.price.management.local.constant.PriceDirectDataConstant;
import com.biz.crm.mdm.business.price.management.sdk.dto.PriceDirectDataDto;
import com.biz.crm.mdm.business.price.management.sdk.service.PriceManagementService;
import com.biz.crm.mdm.business.price.management.sdk.vo.PriceDirectDataImportsVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 预价格管理主数据
 *
 * @author huojia
 * @date 2022年10月25日 15:28
 */
@Slf4j
@Component
public class PriceDirectDataImportsProcess implements ImportProcess<PriceDirectDataImportsVo> {

    @Autowired
    public PriceFormService priceFormService;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Resource
    private DictToolkitService dictToolkitService;

    @Resource
    private ProductVoService productVoService;

    @Resource
    private PriceManagementService priceManagementService;

    private Map<String, String> mdmPriceFormTypeMap = new HashMap<>();
    private Map<String, String> mdmPricingDimensionMap = new HashMap<>();
    private Map<String, ProductVo> productVoMap = new HashMap<>();

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, PriceDirectDataImportsVo> data,
                                        TaskGlobalParamsVo paramsVo,
                                        Map<String, Object> params) {
        Validate.notEmpty(data, "导入数据不能为空！");
        List<PriceDirectDataDto> importList = this.validate(data);
        priceManagementService.importSave(importList);
        return null;
    }


    /**
     * 校验并转换数据
     *
     * @param data
     * @return java.util.List<com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto>
     * @author huojia
     * @date 2022/10/28 14:31
     **/
    private List<PriceDirectDataDto> validate(LinkedHashMap<Integer, PriceDirectDataImportsVo> data) {
        List<PriceDirectDataImportsVo> priceDirectDataImportsVos = new ArrayList<>(data.values());
        // 构建基础数据map
        this.buildBaseMap(priceDirectDataImportsVos);
        // 校验
        this.validateBase(priceDirectDataImportsVos);
        Collection<PriceDirectDataDto> salesPlanDtoList = nebulaToolkitService.copyCollectionByWhiteList(priceDirectDataImportsVos, PriceDirectDataImportsVo.class, PriceDirectDataDto.class, LinkedHashSet.class, ArrayList.class);
        return new ArrayList<>(salesPlanDtoList);
    }

    private void validateBase(List<PriceDirectDataImportsVo> priceDirectDataImportsVos) {
        priceDirectDataImportsVos.forEach(priceDirectDataImportsVo -> {

            if (!productVoMap.containsKey(priceDirectDataImportsVo.getGoodsCode())) {
                throw new RuntimeException("产品" + priceDirectDataImportsVo.getGoodsCode() + "编码错误！");
            } else {
                priceDirectDataImportsVo.setGoodsName(productVoMap.get(priceDirectDataImportsVo.getGoodsCode()).getProductName());
            }

        });
    }

    /**
     * 获取维度配置，校验基础数据
     *
     * @param dimensionMap
     * @param importsVo
     * @param clazz
     * @author huojia
     * @date 2022/11/12 10:51
     **/
    private void buildDimension(Map<String, List<PriceDirectDataImportsVo>> dimensionMap, PriceDirectDataImportsVo importsVo, Class<PriceDirectDataImportsVo> clazz) {
    }

    /**
     * 构建基础数据map
     *
     * @param priceDirectDataImportsVos
     * @author huojia
     * @date 2022/11/10 21:34
     **/
    private void buildBaseMap(List<PriceDirectDataImportsVo> priceDirectDataImportsVos) {
        // 查询数据字典
        mdmPriceFormTypeMap = dictToolkitService.findConvertMapByDictTypeCode(PriceDirectDataConstant.PRICE_FORM_TYPE);
        mdmPricingDimensionMap = dictToolkitService.findConvertMapByDictTypeCode(PriceDirectDataConstant.PRICING_DIMENSION);

        // 查询主数据数据，校验
        Set<String> goodsCode = priceDirectDataImportsVos.stream().map(PriceDirectDataImportsVo::getGoodsCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> goodsName = priceDirectDataImportsVos.stream().map(PriceDirectDataImportsVo::getGoodsName).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<BigDecimal> price = priceDirectDataImportsVos.stream().map(PriceDirectDataImportsVo::getPrice).filter(Objects::nonNull).collect(Collectors.toSet());

        // 产品
        if (CollectionUtils.isEmpty(goodsCode)) {
            List<ProductVo> productVoList = productVoService.findDetailsByIdsOrProductCodes(null, new ArrayList<>(goodsCode));
            if (!CollectionUtils.isEmpty(productVoList)) {
                productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
            }
        }

    }


    @Override
    public Class<PriceDirectDataImportsVo> findCrmExcelVoClass() {
        return null;
    }

    @Override
    public String getTemplateCode() {
        return null;
    }

    @Override
    public String getTemplateName() {
        return null;
    }
}
