/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.management.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.price.management.sdk.dto.PriceDirectDataDto;
import com.biz.crm.mdm.business.price.management.sdk.service.PriceManagementService;
import com.biz.crm.mdm.business.price.management.sdk.vo.PriceDirectDataVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/priceManagement/priceManagement"})
@Api(tags={"\u4ea7\u54c1\u4e3b\u6570\u636e:PriceManagement\u4ef7\u683c\u7ba1\u7406\u914d\u7f6e"})
public class PriceManagementController {
    private static final Logger log = LoggerFactory.getLogger(PriceManagementController.class);
    @Autowired
    private PriceManagementService priceManagementService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<PriceDirectDataVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u9884\u7b97\u7ba1\u7406\u914d\u7f6e\u8868") PriceDirectDataDto dto) {
        try {
            Page page = this.priceManagementService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u4ef7\u683c\u7ba1\u7406")
    @PostMapping
    public Result<PriceDirectDataVo> create(@RequestBody @ApiParam(name="priceDirectDataDto", value="\u4ef7\u683c\u7ba1\u7406\u4e3b\u6570\u636e") PriceDirectDataDto priceDirectDataDto) {
        try {
            PriceDirectDataVo priceDirectDataVo = this.priceManagementService.create(priceDirectDataDto);
            return Result.ok((Object)priceDirectDataVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u4ef7\u683c\u7ba1\u7406")
    @PatchMapping(value={"/update"})
    public Result<String> update(@RequestBody PriceDirectDataDto dto) {
        try {
            String update = this.priceManagementService.update(dto);
            return Result.ok((String)update);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u542f\u7528")
    @PatchMapping(value={"/enableBatch"})
    public Result<?> enable(@RequestBody List<String> ids) {
        this.priceManagementService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u6279\u91cf\u7981\u7528")
    @PatchMapping(value={"/disableBatch"})
    public Result<?> disable(@RequestBody List<String> ids) {
        this.priceManagementService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value=" \u6839\u636e\u4ea7\u54c1\u7f16\u7801\uff0c\u901a\u8fc7\u4ea7\u54c1\u7f16\u7801\u83b7\u53d6\u5bf9\u4ea7\u54c1\u7ba1\u7406\u57fa\u672c\u4fe1\u606f")
    @GetMapping
    public Result<PriceDirectDataVo> listByProductCode(@RequestParam(value="pricingRecordNumber") String pricingRecordNumber) {
        try {
            PriceDirectDataVo result = this.priceManagementService.listByPricingRecordNumber(pricingRecordNumber);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952eid\u67e5\u8be6\u60c5")
    @GetMapping(value={"/findById"})
    public Result<PriceDirectDataVo> findById(@RequestParam String id) {
        try {
            PriceDirectDataVo result = this.priceManagementService.findById(id);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

