/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.management.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.price.management.local.entity.PriceDirectData;
import com.biz.crm.mdm.business.price.management.local.mapper.PriceManagementMapper;
import com.biz.crm.mdm.business.price.management.sdk.dto.PriceDirectDataDto;
import com.biz.crm.mdm.business.price.management.sdk.vo.PriceDirectDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PriceManagementRepository
extends ServiceImpl<PriceManagementMapper, PriceDirectData> {
    @Autowired
    private PriceManagementMapper priceManagementMapper;

    public Page<PriceDirectDataVo> findByConditions(Pageable pageable, PriceDirectDataDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.priceManagementMapper.findByConditions((Page<PriceDirectDataVo>)page, dto);
    }

    public PriceDirectData findByPricingRecordNumber(String pricingRecordNumber) {
        return (PriceDirectData)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PriceDirectData::getPricingRecordNumber, (Object)pricingRecordNumber)).one());
    }

    public PriceDirectDataVo getByPriceUpdatedLastTime(String pricingDimension) {
        return this.priceManagementMapper.getByPriceUpdatedLastTime(pricingDimension);
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public PriceDirectData listByPricingRecordNumber(String pricingRecordNumber) {
        return (PriceDirectData)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PriceDirectData::getPricingRecordNumber, (Object)pricingRecordNumber)).one());
    }

    public PriceDirectData findByIdAndTenantCode(String id, String tenantCode) {
        return (PriceDirectData)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public PriceDirectData deleteById(String delFlag, String id) {
        return (PriceDirectData)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)delFlag)).eq(UuidEntity::getId, (Object)id)).one());
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }
}

