/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.management.local.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.price.management.local.entity.PriceDirectData;
import com.biz.crm.mdm.business.price.management.local.repository.PriceManagementRepository;
import com.biz.crm.mdm.business.price.management.sdk.dto.PriceDirectDataDto;
import com.biz.crm.mdm.business.price.management.sdk.dto.PriceDirectDataLogEventDto;
import com.biz.crm.mdm.business.price.management.sdk.enmus.ValidStateEnum;
import com.biz.crm.mdm.business.price.management.sdk.event.log.PriceDirectLogEventListener;
import com.biz.crm.mdm.business.price.management.sdk.service.PriceManagementService;
import com.biz.crm.mdm.business.price.management.sdk.vo.PriceDirectDataVo;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="priceManagementService")
public class PriceManagementServiceImpl
implements PriceManagementService {
    private static final Logger log = LoggerFactory.getLogger(PriceManagementServiceImpl.class);
    @Autowired
    private PriceManagementRepository priceManagementRepository;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public Page<PriceDirectDataVo> findByConditions(Pageable pageable, PriceDirectDataDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new PriceDirectDataDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.priceManagementRepository.findByConditions(pageable, dto);
    }

    public PriceDirectDataVo create(PriceDirectDataDto dto) {
        Date now = new Date();
        PriceDirectDataVo PriceUpdatedLastTime = null;
        this.extracted(dto);
        PriceDirectData priceDirectData = this.priceManagementRepository.findByPricingRecordNumber(dto.getPricingRecordNumber());
        Validate.isTrue((boolean)Objects.isNull((Object)priceDirectData), (String)"\u5df2\u5b58\u5728\u5f53\u524d\u4ef7\u683c\u7ba1\u7406\u7f16\u7801\u7684\u6570\u636e", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        String ruleCode = "DJA";
        String promotionCode = (String)this.generateCodeService.generateCode(ruleCode, 1).get(0);
        dto.setPricingRecordNumber(promotionCode);
        dto.setCreateTime(new Date());
        if (dto.getStartTime().getTime() > now.getTime()) {
            dto.setValidState(ValidStateEnum.NOT_IN_EFFECT.getCode());
        } else if (now.getTime() > dto.getStartTime().getTime() || now.getTime() < dto.getEndTime().getTime()) {
            dto.setValidState(ValidStateEnum.IN_EFFECT.getCode());
        } else if (now.getTime() > dto.getEndTime().getTime()) {
            dto.setValidState(ValidStateEnum.OUT_OF_DATE.getCode());
        } else {
            dto.setValidState(ValidStateEnum.DISABLED.getCode());
        }
        PriceDirectData result = (PriceDirectData)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, PriceDirectData.class, HashSet.class, ArrayList.class, new String[0]));
        this.priceManagementRepository.save((Object)result);
        PriceDirectDataLogEventDto logEventDto = new PriceDirectDataLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = PriceDirectLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceDirectLogEventListener.class, (SerializableBiConsumer)onCreate);
        return PriceUpdatedLastTime;
    }

    private void extracted(PriceDirectDataDto dto) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getPricingDimension()), (String)"\u5b9a\u4ef7\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getPriceFormCode()), (String)"\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getClient()), (String)"\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getGoodsName()), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getGoodsCode()), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getPrice(), (String)"\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartTime(), (String)"\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndTime(), (String)"\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getPriceFormName()), (String)"\u4ef7\u683c\u7c7b\u578b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getPriceFormCode().length() < 64 ? 1 : 0) != 0, (String)"\u4ef7\u683c\u7c7b\u578b\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u8f93\u5165\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dto.getPriceFormName().length() < 128 ? 1 : 0) != 0, (String)"\u4ef7\u683c\u7c7b\u578b\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u8f93\u5165\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    public String update(PriceDirectDataDto dto) {
        this.updateValidation(dto);
        PriceDirectData priceDirectData = this.priceManagementRepository.findByPricingRecordNumber(dto.getPricingRecordNumber());
        Validate.notNull((Object)((Object)priceDirectData), (String)"\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)priceDirectData.getPricingRecordNumber().equals(dto.getPricingRecordNumber()), (String)"\u5b9a\u4ef7\u8bb0\u5f55\u53f7\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        PriceDirectData priceDirectData1 = (PriceDirectData)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, PriceDirectData.class, HashSet.class, ArrayList.class, new String[0]));
        this.priceManagementRepository.saveOrUpdate((Object)priceDirectData1);
        PriceDirectDataDto priceDirectDataDto = (PriceDirectDataDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)priceDirectData, PriceDirectDataDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        PriceDirectDataLogEventDto logEventDto = new PriceDirectDataLogEventDto();
        logEventDto.setOriginal(priceDirectDataDto);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = PriceDirectLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceDirectLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return "\u66f4\u65b0\u6210\u529f";
    }

    public PriceDirectDataVo listByPricingRecordNumber(String pricingRecordNumber) {
        PriceDirectData priceDirectData = this.priceManagementRepository.listByPricingRecordNumber(pricingRecordNumber);
        PriceDirectDataVo result = (PriceDirectDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)priceDirectData, PriceDirectDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        return result;
    }

    private void updateValidation(PriceDirectDataDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPriceFormCode(), (String)"\u4ef7\u683c\u7c7b\u578b\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPricingRecordNumber(), (String)"\u5b9a\u4ef7\u8bb0\u5f55\u53f7\u7f16\u7801", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)dto.getPriceFormName()) || dto.getGoodsName().length() < 128 ? 1 : 0) != 0, (String)"\u5546\u54c1\u548c\u4ef7\u683c\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    public void importSave(List<PriceDirectDataDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        importList.forEach(dto -> {
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setPriceFormCode(DataFromEnum.IMPORT.getCode());
        });
        Collection salesGoalEntities = this.nebulaToolkitService.copyCollectionByWhiteList(importList, PriceDirectDataDto.class, PriceDirectData.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.priceManagementRepository.saveBatch(salesGoalEntities);
        importList.forEach(dto -> {
            PriceDirectDataLogEventDto logEventDto = new PriceDirectDataLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = PriceDirectLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PriceDirectLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    public PriceDirectDataVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        PriceDirectData result = this.priceManagementRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        PriceDirectData priceDirectData = this.priceManagementRepository.deleteById(result.getDelFlag(), id);
        PriceDirectDataVo priceFormVo = (PriceDirectDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)priceDirectData, PriceDirectDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        return priceFormVo;
    }

    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.priceManagementRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.priceManagementRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
    }
}

