/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.management.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.price.form.sdk.service.PriceFormService;
import com.biz.crm.mdm.business.price.management.sdk.dto.PriceDirectDataDto;
import com.biz.crm.mdm.business.price.management.sdk.service.PriceManagementService;
import com.biz.crm.mdm.business.price.management.sdk.vo.PriceDirectDataImportsVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PriceDirectDataImportsProcess
implements ImportProcess<PriceDirectDataImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(PriceDirectDataImportsProcess.class);
    @Autowired
    public PriceFormService priceFormService;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private DictToolkitService dictToolkitService;
    @Resource
    private ProductVoService productVoService;
    @Resource
    private PriceManagementService priceManagementService;
    private Map<String, String> mdmPriceFormTypeMap = new HashMap<String, String>();
    private Map<String, String> mdmPricingDimensionMap = new HashMap<String, String>();
    private Map<String, ProductVo> productVoMap = new HashMap<String, ProductVo>();

    public Map<Integer, String> execute(LinkedHashMap<Integer, PriceDirectDataImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<PriceDirectDataDto> importList = this.validate(data);
        this.priceManagementService.importSave(importList);
        return null;
    }

    private List<PriceDirectDataDto> validate(LinkedHashMap<Integer, PriceDirectDataImportsVo> data) {
        ArrayList<PriceDirectDataImportsVo> priceDirectDataImportsVos = new ArrayList<PriceDirectDataImportsVo>(data.values());
        this.buildBaseMap(priceDirectDataImportsVos);
        this.validateBase(priceDirectDataImportsVos);
        Collection salesPlanDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(priceDirectDataImportsVos, PriceDirectDataImportsVo.class, PriceDirectDataDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<PriceDirectDataDto>(salesPlanDtoList);
    }

    private void validateBase(List<PriceDirectDataImportsVo> priceDirectDataImportsVos) {
        priceDirectDataImportsVos.forEach(priceDirectDataImportsVo -> {
            if (!this.productVoMap.containsKey(priceDirectDataImportsVo.getGoodsCode())) {
                throw new RuntimeException("\u4ea7\u54c1" + priceDirectDataImportsVo.getGoodsCode() + "\u7f16\u7801\u9519\u8bef\uff01");
            }
            priceDirectDataImportsVo.setGoodsName(this.productVoMap.get(priceDirectDataImportsVo.getGoodsCode()).getProductName());
        });
    }

    private void buildDimension(Map<String, List<PriceDirectDataImportsVo>> dimensionMap, PriceDirectDataImportsVo importsVo, Class<PriceDirectDataImportsVo> clazz) {
    }

    private void buildBaseMap(List<PriceDirectDataImportsVo> priceDirectDataImportsVos) {
        List productVoList;
        this.mdmPriceFormTypeMap = this.dictToolkitService.findConvertMapByDictTypeCode("price_form_type");
        this.mdmPricingDimensionMap = this.dictToolkitService.findConvertMapByDictTypeCode("pricing_dimension");
        Set goodsCode = priceDirectDataImportsVos.stream().map(PriceDirectDataImportsVo::getGoodsCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set goodsName = priceDirectDataImportsVos.stream().map(PriceDirectDataImportsVo::getGoodsName).filter(Objects::nonNull).collect(Collectors.toSet());
        Set price = priceDirectDataImportsVos.stream().map(PriceDirectDataImportsVo::getPrice).filter(Objects::nonNull).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(goodsCode) && !CollectionUtils.isEmpty((Collection)(productVoList = this.productVoService.findDetailsByIdsOrProductCodes(null, new ArrayList(goodsCode))))) {
            this.productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
    }

    public Class<PriceDirectDataImportsVo> findCrmExcelVoClass() {
        return null;
    }

    public String getTemplateCode() {
        return null;
    }

    public String getTemplateName() {
        return null;
    }
}

