package com.biz.crm.mdm.business.price.management.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.price.management.sdk.dto.PriceDirectDataDto;
import com.biz.crm.mdm.business.price.management.sdk.vo.PriceDirectDataEventVo;
import com.biz.crm.mdm.business.price.management.sdk.vo.PriceDirectDataVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * (PriceManagementService)service实现类
 *
 * @author makejava
 * @since 2022-11-19 17:14:14
 */
public interface PriceManagementService {

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    Page<PriceDirectDataVo> findByConditions(Pageable pageable, PriceDirectDataDto dto);

    /**
     * 新增价格管理
     *
     * @param priceDirectDataDto 查询实体
     * @return 所有数据
     */
    PriceDirectDataVo create(PriceDirectDataDto priceDirectDataDto);

    /**
     * 更新价格管理
     *
     * @param dto 请求参数dto
     * @return 职位实体
     */
    String update(PriceDirectDataDto dto);

    /**
     * 批量启用职位
     *
     * @param ids 职位id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 批量禁用财年
     *
     * @param ids 财年id集合
     */
    void disableBatch(List<String> ids);

    /**
     * 根据定价记录号，通过产品编码获取对价格管理基本信息
     *
     * @param pricingRecordNumber
     */
    PriceDirectDataVo listByPricingRecordNumber(String pricingRecordNumber);

    /**
     * 批量导入
     *
     * @param importList
     */
    void importSave(List<PriceDirectDataDto> importList);

    /**
     * 查详情
     */
    PriceDirectDataVo findById(String id);
}
